/*
 * Decompiled with CFR 0.152.
 */
package jp.co.intellilink.hinemos.test.monitor.snmp;

import com.clustercontrol.monitor.run.bean.MonitorInfo;
import com.clustercontrol.monitor.run.bean.MonitorTypeConstant;
import com.clustercontrol.snmp.ejb.session.MonitorSnmpController;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import jp.co.intellilink.hinemos.test.monitor.CheckResultMonitor;
import jp.co.intellilink.hinemos.test.util.Config;
import jp.co.intellilink.hinemos.test.util.EjbConnectionManager;
import jp.co.intellilink.hinemos.test.util.Messages;
import jp.co.intellilink.hinemos.test.util.StringListComparator;
import jp.co.intellilink.hinemos.test.util.WriteCsvFile;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CheckResultMonitorSnmp
extends CheckResultMonitor {
    private static Log log = LogFactory.getLog(CheckResultMonitorSnmp.class);

    public CheckResultMonitorSnmp(Date date) {
        super(date);
    }

    public void checkResult() {
        log.info((Object)("[" + Messages.getMsg("CheckResult") + "] " + Messages.getMsg("TestTool.Snmp.Start")));
        ArrayList<ArrayList<String>> arrayList = new ArrayList<ArrayList<String>>();
        ArrayList arrayList2 = this.getSnmpList();
        if (arrayList2 instanceof ArrayList) {
            for (ArrayList arrayList3 : arrayList2) {
                int n = MonitorTypeConstant.stringToType((String)((String)arrayList3.get(3)));
                if (n != 1) continue;
                Object[] objectArray = new Object[]{(String)arrayList3.get(0)};
                log.info((Object)("[" + Messages.getMsg("CheckResult") + "] " + Messages.getMsg("TestTool.MonitorID", objectArray)));
                MonitorInfo monitorInfo = this.getSnmp((String)arrayList3.get(0), n);
                arrayList.addAll(this.createCheckResult(monitorInfo));
            }
            Collections.sort(arrayList, new StringListComparator(1));
            Collections.sort(arrayList, new StringListComparator(0));
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMdd_HHmmss");
        WriteCsvFile.writeCsvFile(Config.getConfig("Check.Output.Dir") + "/SNMP_" + simpleDateFormat.format(new Date()) + ".csv", arrayList);
        log.info((Object)("[" + Messages.getMsg("CheckResult") + "] " + Messages.getMsg("TestTool.Snmp.End")));
    }

    protected MonitorInfo getSnmp(String string, int n) {
        MonitorSnmpController monitorSnmpController = EjbConnectionManager.getConnectionManager().getMonitorSnmpController();
        MonitorInfo monitorInfo = null;
        try {
            monitorInfo = monitorSnmpController.getSnmp(string, n);
        }
        catch (Exception exception) {
            log.error((Object)("[" + Messages.getMsg("CheckResult") + "] " + Messages.getMsg("TestTool.ConnectManagerFailed")), (Throwable)exception);
            System.exit(14);
        }
        return monitorInfo;
    }

    protected ArrayList getSnmpList() {
        MonitorSnmpController monitorSnmpController = EjbConnectionManager.getConnectionManager().getMonitorSnmpController();
        ArrayList arrayList = null;
        try {
            arrayList = monitorSnmpController.getSnmpList();
        }
        catch (Exception exception) {
            log.error((Object)("[" + Messages.getMsg("CheckResult") + "] " + Messages.getMsg("TestTool.ConnectManagerFailed")), (Throwable)exception);
            System.exit(14);
        }
        return arrayList;
    }
}

