/*
 * Decompiled with CFR 0.152.
 */
package jp.co.intellilink.hinemos.importtool.conf.monitor;

import com.clustercontrol.bean.PriorityConstant;
import com.clustercontrol.monitor.run.bean.MonitorCheckInfo;
import com.clustercontrol.monitor.run.bean.MonitorInfo;
import com.clustercontrol.sql.bean.MonitorSqlInfo;
import com.clustercontrol.sql.ejb.session.MonitorSqlController;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.ejb.DuplicateKeyException;
import jp.co.intellilink.hinemos.importtool.conf.monitor.ImportMonitorString;
import jp.co.intellilink.hinemos.importtool.conf.monitor.JdbcDriverUtil;
import jp.co.intellilink.hinemos.util.CheckString;
import jp.co.intellilink.hinemos.util.Config;
import jp.co.intellilink.hinemos.util.EjbConnectionManager;
import jp.co.intellilink.hinemos.util.Messages;
import jp.co.intellilink.hinemos.util.ReadCsvFile;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImportMonitorSql
extends ImportMonitorString {
    private static Log log = LogFactory.getLog(ImportMonitorSql.class);
    private ArrayList monitorList = null;
    private ArrayList<ArrayList<String>> monitorInfos = null;

    public void importSql() {
        log.info((Object)Messages.getMsg("Sql.Start", new String[]{Messages.getMsg("ImportTool.Import")}));
        this.monitorInfos = ReadCsvFile.readCsvFile(Config.getConfig("Import.Dir") + "/SQL_STR.csv");
        this.monitorRuleInfos = ReadCsvFile.readCsvFile(Config.getConfig("Import.Dir") + "/SQL_STR_RULE.csv");
        this.monitorList = this.getMonitorList();
        for (ArrayList<String> arrayList : this.monitorInfos) {
            MonitorInfo monitorInfo = this.createMonitorInfo(arrayList);
            this.registerMonitorInfo(monitorInfo);
        }
        log.info((Object)Messages.getMsg("Sql.End", new String[]{Messages.getMsg("ImportTool.Import")}));
    }

    @Override
    protected MonitorInfo createMonitorInfo(ArrayList<String> arrayList) {
        MonitorInfo monitorInfo = new MonitorInfo();
        this.createMonitorBase(arrayList, monitorInfo);
        this.createMonitorRule(arrayList.subList(3, 5), monitorInfo);
        this.createMonitorCheck(arrayList.subList(5, 10), monitorInfo);
        this.createMonitorNotify(arrayList.subList(10, 15), monitorInfo);
        this.createMonitorApplication(arrayList.subList(15, 16), monitorInfo);
        if (arrayList.get(16) instanceof String && arrayList.get(16).length() > 0) {
            monitorInfo.setFailurePriority(PriorityConstant.stringToType((String)arrayList.get(16)));
        }
        this.createMonitorVaild(arrayList.subList(17, 18), monitorInfo);
        this.createMonitorJudgement(monitorInfo);
        return monitorInfo;
    }

    @Override
    protected void createMonitorCheck(List<String> list, MonitorInfo monitorInfo) {
        Object[] objectArray;
        Object[] objectArray2;
        MonitorSqlInfo monitorSqlInfo = new MonitorSqlInfo();
        String string = CheckString.checkLength(list.get(0), 256);
        if (!string.equals(list.get(0))) {
            objectArray2 = new String[]{com.clustercontrol.util.Messages.getString((String)"connection.url"), "256"};
            log.warn((Object)Messages.getMsg("ImportTool.Common.2", objectArray2));
        }
        monitorSqlInfo.setConnectionUrl(string);
        objectArray2 = JdbcDriverUtil.getJdbcDriver();
        for (List<String> object2 : objectArray2) {
            objectArray = object2.get(0);
            if (!objectArray.equals(list.get(1))) continue;
            monitorSqlInfo.setJdbcDriver(object2.get(1));
            break;
        }
        String string2 = CheckString.checkLength(list.get(2), 64);
        if (!string.equals(list.get(2))) {
            Object[] objectArray3 = new String[]{com.clustercontrol.util.Messages.getString((String)"user.id"), "64"};
            log.warn((Object)Messages.getMsg("ImportTool.Common.2", objectArray3));
        }
        monitorSqlInfo.setUser(string2);
        String string3 = CheckString.checkLength(list.get(3), 64);
        if (!string3.equals(list.get(3))) {
            objectArray = new String[]{com.clustercontrol.util.Messages.getString((String)"password"), "64"};
            log.warn((Object)Messages.getMsg("ImportTool.Common.2", objectArray));
        }
        monitorSqlInfo.setPassword(string3);
        objectArray = CheckString.checkLength(list.get(4), 1024);
        if (!objectArray.equals(list.get(4))) {
            Object[] objectArray4 = new String[]{com.clustercontrol.util.Messages.getString((String)"sql.string"), "1024"};
            log.warn((Object)Messages.getMsg("ImportTool.Common.2", objectArray4));
        }
        monitorSqlInfo.setQuery((String)objectArray);
        monitorInfo.setCheckInfo((MonitorCheckInfo)monitorSqlInfo);
        monitorInfo.setMonitorType(2);
        super.createMonitorCheck(list, monitorInfo);
    }

    protected void registerMonitorInfo(MonitorInfo monitorInfo) {
        MonitorSqlController monitorSqlController = EjbConnectionManager.getConnectionManager().getMonitorSqlController();
        try {
            ArrayList arrayList = this.checkMonitorList(monitorInfo.getMonitorId(), this.monitorList);
            if (arrayList instanceof ArrayList) {
                Date date = (Date)arrayList.get(8);
                String string = (String)arrayList.get(7);
                monitorInfo.setRegDate(new Timestamp(date.getTime()));
                monitorInfo.setRegUser(string);
                Object[] objectArray = new Object[]{monitorInfo.getMonitorId()};
                log.info((Object)(Messages.getMsg("MonitorID", objectArray) + " (" + Messages.getMsg("modify") + ")"));
                monitorSqlController.modifySql(monitorInfo);
            } else {
                Object[] objectArray = new Object[]{monitorInfo.getMonitorId()};
                log.info((Object)(Messages.getMsg("MonitorID", objectArray) + " (" + Messages.getMsg("add") + ")"));
                monitorSqlController.addSql(monitorInfo);
            }
        }
        catch (DuplicateKeyException duplicateKeyException) {
            Object[] objectArray = new String[]{monitorInfo.getMonitorId()};
            log.error((Object)Messages.getMsg("ImportTool.Common.1", objectArray));
            System.exit(20);
        }
        catch (Exception exception) {
            log.error((Object)Messages.getMsg("ConnectManagerFailed"), (Throwable)exception);
            System.exit(14);
        }
    }

    protected ArrayList getMonitorList() {
        MonitorSqlController monitorSqlController = EjbConnectionManager.getConnectionManager().getMonitorSqlController();
        ArrayList arrayList = null;
        try {
            arrayList = monitorSqlController.getSqlList();
        }
        catch (Exception exception) {
            log.error((Object)Messages.getMsg("ConnectManagerFailed"), (Throwable)exception);
            System.exit(14);
        }
        return arrayList;
    }
}

