/*
 * Decompiled with CFR 0.152.
 */
package jp.co.dgic.testing.common.virtualmock;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import jp.co.dgic.testing.common.DJUnitRuntimeException;

class ReturnValueList {
    private static final String MESSAGE_VALUE_IS_NULL = "Return value must be NOT null.";
    protected Hashtable valueTable = new Hashtable();
    protected Hashtable valueAtAllTimesTable = new Hashtable();

    ReturnValueList() {
    }

    public void clear() {
        this.valueTable.clear();
        this.valueAtAllTimesTable.clear();
    }

    public Object get(String key) {
        return this.get(key, true);
    }

    public Object get(String key, boolean isRemove) {
        Object valueAtAllTimes = this.getValueAtAllTimes(key);
        if (valueAtAllTimes != null) {
            return valueAtAllTimes;
        }
        List values = this.getValueList(key);
        if (values == null) {
            return null;
        }
        if (values.isEmpty()) {
            return null;
        }
        Object value = values.get(0);
        if (isRemove) {
            values.remove(0);
        }
        return value;
    }

    public void put(String key, Object value) {
        this.throwReturnValueMustBeNotNullException(key, value);
        ArrayList<Object> values = this.getValueList(key);
        if (values == null) {
            values = new ArrayList<Object>();
        }
        values.add(value);
        this.valueTable.put(key, values);
    }

    public void setAt(String key, int index, Object value) {
        int size;
        int maxIndex;
        this.throwReturnValueMustBeNotNullException(key, value);
        ArrayList<Object> values = this.getValueList(key);
        if (values == null) {
            values = new ArrayList<Object>();
        }
        if ((maxIndex = (size = values.size()) - 1) < index) {
            int i = size;
            while (i <= index) {
                values.add(null);
                ++i;
            }
        }
        values.set(index, value);
        this.valueTable.put(key, values);
    }

    public Enumeration keys() {
        return this.valueTable.keys();
    }

    protected List getValueList(String key) {
        List values = this.getValueListByFullName(key);
        if (values == null) {
            values = this.getValueListBySimpleName(key);
        }
        return values;
    }

    protected List getValueListByFullName(String key) {
        if (!this.valueTable.containsKey(key)) {
            return null;
        }
        return (List)this.valueTable.get(key);
    }

    protected List getValueListBySimpleName(String key) {
        Enumeration enumeration = this.valueTable.keys();
        String keyString = null;
        while (enumeration.hasMoreElements()) {
            keyString = (String)enumeration.nextElement();
            if (!key.endsWith("." + keyString)) continue;
            return this.getValueListByFullName(keyString);
        }
        return null;
    }

    protected Object getValueAtAllTimes(String key) {
        Object value = this.valueAtAllTimesTable.get(key);
        if (value == null) {
            value = this.getValueAtAllTimesBySimpleName(key);
        }
        return value;
    }

    protected Object getValueAtAllTimesBySimpleName(String key) {
        Enumeration enumeration = this.valueAtAllTimesTable.keys();
        String keyString = null;
        while (enumeration.hasMoreElements()) {
            keyString = (String)enumeration.nextElement();
            if (!key.endsWith("." + keyString)) continue;
            return this.valueAtAllTimesTable.get(keyString);
        }
        return null;
    }

    public void putValueAtAllTimes(String key, Object value) {
        this.throwReturnValueMustBeNotNullException(key, value);
        this.valueAtAllTimesTable.put(key, value);
    }

    private void throwReturnValueMustBeNotNullException(String key, Object value) {
        if (value == null) {
            throw new DJUnitRuntimeException("Return value must be NOT null.[" + key + "]");
        }
    }
}

