/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop;

import java.lang.reflect.Method;
import org.jboss.aop.Advisor;
import org.jboss.aop.CallerMethodInfo;
import org.jboss.aop.JoinPointInfo;
import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.joinpoint.Joinpoint;
import org.jboss.aop.joinpoint.MethodCalledByMethodJoinpoint;
import org.jboss.aop.util.MethodHashing;

public class MethodByMethodInfo
extends CallerMethodInfo {
    private final long callingMethodHash;
    private final Method callingMethod;

    public MethodByMethodInfo(Advisor advisor, Class calledClass, Method m, long callingMethodHash, long calledMethodHash, Interceptor[] in) {
        super(advisor, calledClass, m, calledMethodHash, in);
        try {
            this.callingMethodHash = callingMethodHash;
            this.callingMethod = MethodHashing.findMethodByHash(this.getCallingClass(), callingMethodHash);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private MethodByMethodInfo(MethodByMethodInfo other) {
        super(other);
        this.callingMethodHash = other.callingMethodHash;
        this.callingMethod = other.callingMethod;
    }

    protected Joinpoint internalGetJoinpoint() {
        return new MethodCalledByMethodJoinpoint(this.callingMethod, this.getMethod());
    }

    public JoinPointInfo copy() {
        return new MethodByMethodInfo(this);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("Method called by Method");
        sb.append("[");
        sb.append("calling=" + this.callingMethod);
        sb.append(",called=" + this.getMethod());
        sb.append("]");
        return sb.toString();
    }

    public long getCallingMethodHash() {
        return this.callingMethodHash;
    }

    public Method getCallingMethod() {
        return this.callingMethod;
    }
}

