/*
 * Decompiled with CFR 0.152.
 */
package jp.co.intellilink.hinemos.test.monitor.http;

import com.clustercontrol.http.ejb.session.MonitorHttpController;
import com.clustercontrol.monitor.run.bean.MonitorInfo;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import jp.co.intellilink.hinemos.test.monitor.ExportTestCaseMonitor;
import jp.co.intellilink.hinemos.test.util.Config;
import jp.co.intellilink.hinemos.test.util.EjbConnectionManager;
import jp.co.intellilink.hinemos.test.util.Messages;
import jp.co.intellilink.hinemos.test.util.StringListComparator;
import jp.co.intellilink.hinemos.test.util.WriteCsvFile;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ExportTestCaseMonitorHttp
extends ExportTestCaseMonitor {
    private static Log log = LogFactory.getLog(ExportTestCaseMonitorHttp.class);

    public void exportTestCase() {
        log.info((Object)("[" + Messages.getMsg("ExportTestCase") + "] " + Messages.getMsg("TestTool.Http.Start")));
        ArrayList<ArrayList<String>> arrayList = new ArrayList<ArrayList<String>>();
        ArrayList arrayList2 = this.getHttpList();
        if (arrayList2 instanceof ArrayList) {
            for (MonitorInfo monitorInfo : arrayList2) {
                if (monitorInfo.getMonitorType() != 1) continue;
                Object[] objectArray = new Object[]{monitorInfo.getMonitorId()};
                log.info((Object)("[" + Messages.getMsg("ExportTestCase") + "] " + Messages.getMsg("TestTool.MonitorID", objectArray)));
                arrayList.addAll(this.createTestCase(monitorInfo));
            }
            Collections.sort(arrayList, new StringListComparator(1));
            Collections.sort(arrayList, new StringListComparator(0));
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMdd_HHmmss");
        WriteCsvFile.writeCsvFile(Config.getConfig("Testcase.Output.Dir") + "/HTTP_" + simpleDateFormat.format(new Date()) + ".csv", arrayList);
        log.info((Object)("[" + Messages.getMsg("ExportTestCase") + "] " + Messages.getMsg("TestTool.Http.End")));
    }

    protected ArrayList getHttpList() {
        MonitorHttpController monitorHttpController = EjbConnectionManager.getConnectionManager().getMonitorHttpController();
        ArrayList arrayList = null;
        try {
            arrayList = monitorHttpController.getHttpList();
        }
        catch (Exception exception) {
            log.error((Object)("[" + Messages.getMsg("ExportTestCase") + "] " + Messages.getMsg("TestTool.ConnectManagerFailed")), (Throwable)exception);
            System.exit(14);
        }
        return arrayList;
    }
}

