/*
 * Decompiled with CFR 0.152.
 */
package jp.co.intellilink.hinemos.test.job;

import com.clustercontrol.bean.DayOfWeekConstant;
import com.clustercontrol.bean.Schedule;
import com.clustercontrol.jobmanagement.bean.JobHistory;
import com.clustercontrol.jobmanagement.bean.JobHistoryFilter;
import com.clustercontrol.jobmanagement.bean.JobHistoryList;
import com.clustercontrol.jobmanagement.bean.JobSchedule;
import com.clustercontrol.jobmanagement.ejb.session.JobController;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import jp.co.intellilink.hinemos.test.util.Config;
import jp.co.intellilink.hinemos.test.util.EjbConnectionManager;
import jp.co.intellilink.hinemos.test.util.Messages;
import jp.co.intellilink.hinemos.test.util.StringListComparator;
import jp.co.intellilink.hinemos.test.util.WriteCsvFile;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CheckResultSchedule {
    private Date fromDate;
    private Date toDate;
    private static Log log = LogFactory.getLog(CheckResultSchedule.class);

    public CheckResultSchedule(Date date, Date date2) {
        this.fromDate = date;
        this.toDate = date2;
    }

    public void checkResult() {
        log.info((Object)("[" + Messages.getMsg("CheckResult") + "] " + Messages.getMsg("TestTool.Job.Schedule.Start")));
        ArrayList<ArrayList<String>> arrayList = new ArrayList<ArrayList<String>>();
        ArrayList arrayList2 = this.getScheduleList();
        if (arrayList2 instanceof ArrayList) {
            for (JobSchedule jobSchedule : arrayList2) {
                Object[] objectArray = new Object[]{jobSchedule.getId()};
                log.info((Object)Messages.getMsg("TestTool.ScheduleID", objectArray));
                arrayList.add(this.createCheckResult(jobSchedule));
            }
            Collections.sort(arrayList, new StringListComparator(0));
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMdd_HHmmss");
        WriteCsvFile.writeCsvFile(Config.getConfig("Check.Output.Dir") + "/JOB_SCHEDULE_" + simpleDateFormat.format(new Date()) + ".csv", arrayList);
        log.info((Object)("[" + Messages.getMsg("CheckResult") + "] " + Messages.getMsg("TestTool.Job.Schedule.End")));
    }

    public ArrayList<String> createCheckResult(JobSchedule jobSchedule) {
        ArrayList<String> arrayList;
        block2: {
            Iterator iterator;
            arrayList = new ArrayList<String>();
            arrayList.add(jobSchedule.getId());
            arrayList.add(jobSchedule.getName());
            arrayList.add(jobSchedule.getJobId());
            arrayList.add(jobSchedule.getJobName());
            arrayList.add(this.createSchedule(jobSchedule.getSchedule()));
            JobHistoryList jobHistoryList = this.getSessionList(jobSchedule.getJobId());
            if (!(jobHistoryList.getList() instanceof ArrayList) || !(iterator = jobHistoryList.getList().iterator()).hasNext()) break block2;
            JobHistory jobHistory = (JobHistory)iterator.next();
            String string = "";
            String string2 = "";
            if (jobHistory.getStartDate() instanceof Date) {
                string = DateFormat.getDateTimeInstance().format(jobHistory.getStartDate());
            }
            if (jobHistory.getEndDate() instanceof Date) {
                string2 = DateFormat.getDateTimeInstance().format(jobHistory.getEndDate());
            }
            arrayList.add(string);
            arrayList.add(string2);
        }
        return arrayList;
    }

    protected String createSchedule(Schedule schedule) {
        String string = "";
        if (schedule.getType() == 0) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MM/dd HH:mm");
            if (schedule.getDate() instanceof Date) {
                string = simpleDateFormat.format(schedule.getDate());
            }
        } else if (schedule.getType() == 1) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd'" + com.clustercontrol.util.Messages.getString((String)"monthday") + "' HH:mm");
            if (schedule.getDate() instanceof Date) {
                string = simpleDateFormat.format(schedule.getDate());
            }
        } else if (schedule.getType() == 2) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("HH:mm");
            if (schedule.getDate() instanceof Date) {
                string = simpleDateFormat.format(schedule.getDate());
            }
        } else if (schedule.getType() == 3) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("mm'" + com.clustercontrol.util.Messages.getString((String)"minute") + "'");
            if (schedule.getDate() instanceof Date) {
                string = simpleDateFormat.format(schedule.getDate());
            }
        } else if (schedule.getType() == 4) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(" HH:mm");
            if (schedule.getDate() instanceof Date) {
                string = DayOfWeekConstant.typeToString((int)schedule.getDayOfWeek()) + simpleDateFormat.format(schedule.getDate());
            }
        }
        return string;
    }

    public String getStringValue(ArrayList arrayList, int n) {
        if (arrayList.size() > n - 1 && arrayList.get(n) instanceof String) {
            return (String)arrayList.get(n);
        }
        return "";
    }

    protected JobHistoryList getSessionList(String string) {
        JobController jobController = EjbConnectionManager.getConnectionManager().getJobController();
        JobHistoryList jobHistoryList = null;
        try {
            JobHistoryFilter jobHistoryFilter = new JobHistoryFilter();
            if (string instanceof String) {
                jobHistoryFilter.setJobId(string);
            }
            if (this.fromDate instanceof Date) {
                jobHistoryFilter.setStartFromDate(this.fromDate);
            }
            if (this.toDate instanceof Date) {
                jobHistoryFilter.setStartToDate(this.toDate);
            }
            int n = Integer.parseInt(Config.getConfig("history.job.max.list"));
            jobHistoryList = jobController.getHistoryList(jobHistoryFilter, n);
        }
        catch (Exception exception) {
            log.error((Object)Messages.getMsg("TestTool.ConnectManagerFailed"), (Throwable)exception);
            System.exit(14);
        }
        return jobHistoryList;
    }

    protected ArrayList getScheduleList() {
        JobController jobController = EjbConnectionManager.getConnectionManager().getJobController();
        ArrayList arrayList = null;
        try {
            arrayList = jobController.getScheduleList();
        }
        catch (Exception exception) {
            log.error((Object)Messages.getMsg("TestTool.ConnectManagerFailed"), (Throwable)exception);
            System.exit(14);
        }
        return arrayList;
    }
}

