/*
 * Decompiled with CFR 0.152.
 */
package jp.co.intellilink.hinemos.importtool.conf.job;

import com.clustercontrol.bean.EndStatusConstant;
import com.clustercontrol.bean.JobConstant;
import com.clustercontrol.bean.JobParamTypeConstant;
import com.clustercontrol.bean.JudgmentObjectConstant;
import com.clustercontrol.bean.PriorityConstant;
import com.clustercontrol.bean.YesNoConstant;
import com.clustercontrol.jobmanagement.bean.ConditionTypeConstant;
import com.clustercontrol.jobmanagement.bean.JobCommandInfo;
import com.clustercontrol.jobmanagement.bean.JobEndStatusInfo;
import com.clustercontrol.jobmanagement.bean.JobFileInfo;
import com.clustercontrol.jobmanagement.bean.JobInfo;
import com.clustercontrol.jobmanagement.bean.JobNotificationsInfo;
import com.clustercontrol.jobmanagement.bean.JobObjectInfo;
import com.clustercontrol.jobmanagement.bean.JobParameterInfo;
import com.clustercontrol.jobmanagement.bean.JobTreeItem;
import com.clustercontrol.jobmanagement.bean.JobWaitRuleInfo;
import com.clustercontrol.jobmanagement.bean.OperationConstant;
import com.clustercontrol.jobmanagement.ejb.session.JobController;
import com.clustercontrol.notify.bean.NotifyRelationInfo;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Locale;
import jp.co.intellilink.hinemos.importtool.util.CheckString;
import jp.co.intellilink.hinemos.importtool.util.Config;
import jp.co.intellilink.hinemos.importtool.util.EjbConnectionManager;
import jp.co.intellilink.hinemos.importtool.util.JobUtil;
import jp.co.intellilink.hinemos.importtool.util.Messages;
import jp.co.intellilink.hinemos.importtool.util.ReadCsvFile;
import jp.co.intellilink.hinemos.importtool.util.SelectArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImportJob {
    private static Log log = LogFactory.getLog(ImportJob.class);
    private ArrayList<ArrayList<String>> jobInfo = null;
    private ArrayList<ArrayList<String>> waitInfo = null;
    private ArrayList<ArrayList<String>> notifyInfo = null;
    private ArrayList<ArrayList<String>> delayInfo = null;
    private ArrayList<ArrayList<String>> paramInfo = null;
    private SimpleDateFormat formatTime1 = new SimpleDateFormat("HH:mm:ss");
    private SimpleDateFormat formatTime2 = new SimpleDateFormat("HH:mm");

    public void importJob() {
        log.info((Object)Messages.getMsg("ImportTool.Job.Start", new String[]{Messages.getMsg("ImportTool.Import")}));
        this.jobInfo = ReadCsvFile.readCsvFile(Config.getConfig("Input.Dir.Conf") + "/JOB.csv");
        this.waitInfo = ReadCsvFile.readCsvFile(Config.getConfig("Input.Dir.Conf") + "/JOB_WAIT.csv");
        this.notifyInfo = ReadCsvFile.readCsvFile(Config.getConfig("Input.Dir.Conf") + "/JOB_NOTIFY.csv");
        this.delayInfo = ReadCsvFile.readCsvFile(Config.getConfig("Input.Dir.Conf") + "/JOB_DELAY.csv");
        this.paramInfo = ReadCsvFile.readCsvFile(Config.getConfig("Input.Dir.Conf") + "/JOB_PARAM.csv");
        JobTreeItem jobTreeItem = this.createJobTree();
        log.info((Object)Messages.getMsg("ImportTool.Job.Check.WaitRule"));
        if (JobUtil.checkWaitRule(jobTreeItem)) {
            log.info((Object)Messages.getMsg("ImportTool.Job.Check.FacilityID"));
            if (JobUtil.checkFacilityId(jobTreeItem)) {
                log.info((Object)Messages.getMsg("ImportTool.Job.Check.NotifyID"));
                if (JobUtil.checkNotifyId(jobTreeItem)) {
                    this.registerJob(jobTreeItem);
                }
            }
        }
        log.info((Object)Messages.getMsg("ImportTool.Job.End", new String[]{Messages.getMsg("ImportTool.Import")}));
    }

    public JobTreeItem createJobTree() {
        JobInfo jobInfo = new JobInfo("", "", -1);
        JobTreeItem jobTreeItem = new JobTreeItem(null, jobInfo);
        jobInfo = new JobInfo("", com.clustercontrol.util.Messages.getString((String)"job", (Locale)Locale.getDefault()), -1);
        JobTreeItem jobTreeItem2 = new JobTreeItem(jobTreeItem, jobInfo);
        ArrayList<ArrayList<String>> arrayList = SelectArrayList.select(this.jobInfo, 3, com.clustercontrol.util.Messages.getString((String)"jobunit", (Locale)Locale.getDefault()));
        for (ArrayList<String> arrayList2 : arrayList) {
            this.createJobTree(arrayList2, jobTreeItem2);
        }
        return jobTreeItem;
    }

    protected void createJobTree(ArrayList<String> arrayList, JobTreeItem jobTreeItem) {
        JobTreeItem jobTreeItem2 = JobUtil.getTopJobTreeItem(jobTreeItem);
        if (JobUtil.findJobId(arrayList.get(0), jobTreeItem2)) {
            log.error((Object)Messages.getMsg("ImportTool.Job.3", new String[]{arrayList.get(0)}));
            System.exit(14);
        }
        JobInfo jobInfo = this.createJobData(arrayList);
        JobTreeItem jobTreeItem3 = new JobTreeItem(jobTreeItem, jobInfo);
        ArrayList<ArrayList<String>> arrayList2 = SelectArrayList.select(this.jobInfo, 4, arrayList.get(0));
        for (ArrayList<String> arrayList3 : arrayList2) {
            this.createJobTree(arrayList3, jobTreeItem3);
        }
    }

    protected JobInfo createJobData(ArrayList<String> arrayList) {
        ArrayList<Object> arrayList2;
        ArrayList<Object> arrayList3;
        Object object;
        Object object2;
        ArrayList<ArrayList<String>> arrayList4;
        Object object3;
        Object object4;
        String[] stringArray;
        Object[] objectArray;
        Object[] objectArray2;
        log.info((Object)Messages.getMsg("ImportTool.JobID", new String[]{arrayList.get(0)}));
        JobInfo jobInfo = new JobInfo(arrayList.get(0), arrayList.get(1), JobConstant.stringToType((String)arrayList.get(3)));
        String string = CheckString.checkLength(arrayList.get(0), 64);
        if (!string.equals(arrayList.get(0))) {
            objectArray2 = new String[]{com.clustercontrol.util.Messages.getString((String)"job.id"), "64"};
            log.error((Object)Messages.getMsg("ImportTool.Common.2", objectArray2));
            System.exit(20);
        }
        jobInfo.setName(string);
        objectArray2 = CheckString.checkLength(arrayList.get(1), 64);
        if (!objectArray2.equals(arrayList.get(1))) {
            objectArray = new String[]{com.clustercontrol.util.Messages.getString((String)"job.name"), "64"};
            log.warn((Object)Messages.getMsg("ImportTool.Common.2", objectArray));
        }
        jobInfo.setName((String)objectArray2);
        objectArray = CheckString.checkLength(arrayList.get(2), 256);
        if (!objectArray.equals(arrayList.get(2))) {
            stringArray = new String[]{com.clustercontrol.util.Messages.getString((String)"description"), "256"};
            log.warn((Object)Messages.getMsg("ImportTool.Common.2", stringArray));
        }
        jobInfo.setDescription((String)objectArray);
        stringArray = null;
        ArrayList<ArrayList<String>> arrayList5 = SelectArrayList.select(this.delayInfo, 0, arrayList.get(0));
        if (jobInfo.getType() != 0 && arrayList5.size() > 0) {
            stringArray = new JobWaitRuleInfo();
            stringArray.setSuspend(YesNoConstant.stringToType((String)arrayList.get(18)));
            stringArray.setCondition(ConditionTypeConstant.stringToType((String)arrayList.get(12)));
            stringArray.setEndCondition(YesNoConstant.stringToType((String)arrayList.get(13)));
            stringArray.setEndValue(Integer.parseInt(arrayList.get(14)));
            stringArray.setSkip(YesNoConstant.stringToType((String)arrayList.get(19)));
            stringArray.setSkipEndValue(Integer.parseInt(arrayList.get(20)));
            stringArray.setCalendar(YesNoConstant.stringToType((String)arrayList.get(15)));
            if (arrayList.get(16).length() > 0) {
                stringArray.setCalendarId(arrayList.get(16));
            }
            stringArray.setCalendarEndValue(Integer.parseInt(arrayList.get(17)));
            object4 = arrayList5.get(0);
            stringArray.setStart_delay(YesNoConstant.stringToType((String)((String)((ArrayList)object4).get(1))));
            stringArray.setStart_delay_session(YesNoConstant.stringToType((String)((String)((ArrayList)object4).get(2))));
            stringArray.setStart_delay_session_value(Integer.parseInt((String)((ArrayList)object4).get(3)));
            stringArray.setStart_delay_time(YesNoConstant.stringToType((String)((String)((ArrayList)object4).get(4))));
            try {
                stringArray.setStart_delay_time_value(this.formatTime1.parse((String)((ArrayList)object4).get(5)));
            }
            catch (ParseException parseException) {
                try {
                    stringArray.setStart_delay_time_value(this.formatTime2.parse((String)((ArrayList)object4).get(5)));
                }
                catch (ParseException parseException2) {
                    // empty catch block
                }
            }
            stringArray.setStart_delay_condition_type(ConditionTypeConstant.stringToType((String)((String)((ArrayList)object4).get(6))));
            stringArray.setStart_delay_notify(YesNoConstant.stringToType((String)((String)((ArrayList)object4).get(7))));
            stringArray.setStart_delay_notify_priority(PriorityConstant.stringToType((String)((String)((ArrayList)object4).get(8))));
            stringArray.setStart_delay_operation(YesNoConstant.stringToType((String)((String)((ArrayList)object4).get(9))));
            stringArray.setStart_delay_operation_type(OperationConstant.stringToType((String)((String)((ArrayList)object4).get(10))));
            stringArray.setStart_delay_operation_end_value(Integer.parseInt((String)((ArrayList)object4).get(11)));
            stringArray.setEnd_delay(YesNoConstant.stringToType((String)((String)((ArrayList)object4).get(12))));
            stringArray.setEnd_delay_session(YesNoConstant.stringToType((String)((String)((ArrayList)object4).get(13))));
            stringArray.setEnd_delay_session_value(Integer.parseInt((String)((ArrayList)object4).get(14)));
            stringArray.setEnd_delay_job(YesNoConstant.stringToType((String)((String)((ArrayList)object4).get(15))));
            stringArray.setEnd_delay_job_value(Integer.parseInt((String)((ArrayList)object4).get(16)));
            stringArray.setEnd_delay_time(YesNoConstant.stringToType((String)((String)((ArrayList)object4).get(17))));
            try {
                stringArray.setEnd_delay_time_value(this.formatTime1.parse((String)((ArrayList)object4).get(18)));
            }
            catch (ParseException parseException) {
                try {
                    stringArray.setEnd_delay_time_value(this.formatTime2.parse((String)((ArrayList)object4).get(18)));
                }
                catch (ParseException parseException3) {
                    // empty catch block
                }
            }
            stringArray.setEnd_delay_condition_type(ConditionTypeConstant.stringToType((String)((String)((ArrayList)object4).get(19))));
            stringArray.setEnd_delay_notify(YesNoConstant.stringToType((String)((String)((ArrayList)object4).get(20))));
            stringArray.setEnd_delay_notify_priority(PriorityConstant.stringToType((String)((String)((ArrayList)object4).get(21))));
            stringArray.setEnd_delay_operation(YesNoConstant.stringToType((String)((String)((ArrayList)object4).get(22))));
            stringArray.setEnd_delay_operation_type(OperationConstant.stringToType((String)((String)((ArrayList)object4).get(23))));
            stringArray.setEnd_delay_operation_end_value(Integer.parseInt((String)((ArrayList)object4).get(24)));
            object3 = SelectArrayList.select(this.waitInfo, 0, arrayList.get(0));
            arrayList4 = new ArrayList();
            if (((ArrayList)object3).size() > 0) {
                object2 = ((ArrayList)object3).iterator();
                while (object2.hasNext()) {
                    object = (ArrayList)object2.next();
                    arrayList3 = new JobObjectInfo();
                    arrayList3.setType(JudgmentObjectConstant.stringToType((String)((String)((ArrayList)object).get(1))));
                    if (arrayList3.getType() == 0) {
                        arrayList3.setJobId((String)((ArrayList)object).get(2));
                        arrayList3.setValue(EndStatusConstant.stringToType((String)((String)((ArrayList)object).get(3))));
                    } else if (arrayList3.getType() == 1) {
                        arrayList3.setJobId((String)((ArrayList)object).get(2));
                        arrayList3.setValue(Integer.parseInt((String)((ArrayList)object).get(3)));
                    } else if (arrayList3.getType() == 2) {
                        try {
                            arrayList3.setTime(this.formatTime1.parse((String)((ArrayList)object).get(3)));
                        }
                        catch (ParseException parseException) {
                            try {
                                arrayList3.setTime(this.formatTime2.parse((String)((ArrayList)object).get(3)));
                            }
                            catch (ParseException parseException4) {
                                // empty catch block
                            }
                        }
                    }
                    arrayList4.add(arrayList3);
                }
            }
            stringArray.setObject(arrayList4);
            jobInfo.setWaitRule((JobWaitRuleInfo)stringArray);
        }
        object4 = null;
        if (jobInfo.getType() == 2 && arrayList.size() >= 29) {
            object4 = new JobCommandInfo();
            if (com.clustercontrol.util.Messages.getString((String)"fixed.value").compareTo(arrayList.get(21)) == 0) {
                object4.setFacilityID(arrayList.get(22));
            } else {
                object4.setFacilityID("${FACILITY_ID}");
            }
            if (com.clustercontrol.util.Messages.getString((String)"scope.process.all.nodes").compareTo(arrayList.get(23)) == 0) {
                object4.setProcessingMethod(0);
            } else {
                object4.setProcessingMethod(1);
            }
            object4.setStartCommand(arrayList.get(24));
            object4.setStopCommand(arrayList.get(25));
            object4.setUser(arrayList.get(26));
            object4.setErrorEndFlg(YesNoConstant.stringToType((String)arrayList.get(27)));
            object4.setErrorEndValue(Integer.parseInt(arrayList.get(28)));
            jobInfo.setCommand((JobCommandInfo)object4);
        }
        object3 = null;
        if (jobInfo.getType() == 3 && arrayList.size() > 29) {
            object3 = new JobFileInfo();
            if (com.clustercontrol.util.Messages.getString((String)"scope.process.all.nodes").compareTo(arrayList.get(32)) == 0) {
                object3.setProcessingMethod(0);
            } else {
                object3.setProcessingMethod(1);
            }
            object3.setSrcFacilityID(arrayList.get(29));
            object3.setDestFacilityID(arrayList.get(31));
            object3.setSrcFile(arrayList.get(30));
            object3.setSrcWorkDir("");
            object3.setDestDirectory(arrayList.get(33));
            object3.setDestWorkDir("");
            object3.setCompressionFlg(YesNoConstant.stringToType((String)arrayList.get(34)));
            object3.setCheckFlg(YesNoConstant.stringToType((String)arrayList.get(35)));
            object3.setUser(arrayList.get(36));
            jobInfo.setFile((JobFileInfo)object3);
        }
        if ((arrayList4 = SelectArrayList.select(this.notifyInfo, 0, arrayList.get(0))).size() > 0) {
            object2 = arrayList4.get(0);
            object = NotifyRelationInfo.createNotifyGroupIdJob((String)arrayList.get(0), (Integer)0);
            arrayList3 = new ArrayList<NotifyRelationInfo>();
            for (int i = 5; i < 10; ++i) {
                if (((ArrayList)object2).size() <= i || !(((ArrayList)object2).get(i) instanceof String) || ((String)((ArrayList)object2).get(i)).length() <= 0) continue;
                NotifyRelationInfo notifyRelationInfo = new NotifyRelationInfo();
                notifyRelationInfo.setNotifyId((String)((ArrayList)object2).get(i));
                notifyRelationInfo.setNotifyGroupId((String)object);
                notifyRelationInfo.setNotifyFlg(Integer.valueOf(0));
                if (i == 5) {
                    notifyRelationInfo.setNotifyType(Integer.valueOf(0));
                } else if (i == 6) {
                    notifyRelationInfo.setNotifyType(Integer.valueOf(1));
                } else if (i == 7) {
                    notifyRelationInfo.setNotifyType(Integer.valueOf(2));
                } else if (i == 8) {
                    notifyRelationInfo.setNotifyType(Integer.valueOf(3));
                } else if (i == 9) {
                    notifyRelationInfo.setNotifyType(Integer.valueOf(4));
                }
                arrayList3.add(notifyRelationInfo);
            }
            arrayList2 = new ArrayList<Object>();
            for (int i = 0; i < 4; ++i) {
                Object object5 = new JobNotificationsInfo();
                if (i == 0) {
                    object5.setType(0);
                    object5.setPriority(PriorityConstant.stringToType((String)((String)((ArrayList)object2).get(2))));
                } else if (i == 1) {
                    object5.setType(1);
                    object5.setPriority(PriorityConstant.stringToType((String)((String)((ArrayList)object2).get(3))));
                } else if (i == 2) {
                    object5.setType(2);
                    object5.setPriority(PriorityConstant.stringToType((String)((String)((ArrayList)object2).get(4))));
                } else if (i == 3) {
                    object5.setType(3);
                    object5.setPriority(PriorityConstant.stringToType((String)((String)((ArrayList)object2).get(1))));
                }
                object5.setNotifyGroupId((String)object);
                if (object5.getType() == 0) {
                    object5.setNotifyId(arrayList3);
                }
                arrayList2.add(object5);
            }
            jobInfo.setNotifications(arrayList2);
        }
        object2 = new ArrayList();
        object = new JobEndStatusInfo();
        object.setType(0);
        object.setValue(Integer.parseInt(arrayList.get(5)));
        object.setStartRangeValue(Integer.parseInt(arrayList.get(6)));
        object.setEndRangeValue(Integer.parseInt(arrayList.get(7)));
        ((ArrayList)object2).add((Object)object);
        object = new JobEndStatusInfo();
        object.setType(1);
        object.setValue(Integer.parseInt(arrayList.get(8)));
        object.setStartRangeValue(Integer.parseInt(arrayList.get(9)));
        object.setEndRangeValue(Integer.parseInt(arrayList.get(10)));
        ((ArrayList)object2).add((Object)object);
        object = new JobEndStatusInfo();
        object.setType(2);
        object.setValue(Integer.parseInt(arrayList.get(11)));
        object.setStartRangeValue(0);
        object.setEndRangeValue(0);
        ((ArrayList)object2).add((Object)object);
        jobInfo.setEndStatus(object2);
        arrayList3 = SelectArrayList.select(this.paramInfo, 0, arrayList.get(0));
        if (jobInfo.getType() == 0 && arrayList3.size() > 0) {
            arrayList2 = new ArrayList();
            for (Object object5 : arrayList3) {
                JobParameterInfo jobParameterInfo = new JobParameterInfo();
                jobParameterInfo.setParamId((String)((ArrayList)object5).get(1));
                jobParameterInfo.setType(JobParamTypeConstant.stringToType((String)((String)((ArrayList)object5).get(2))));
                jobParameterInfo.setValue((String)((ArrayList)object5).get(3));
                jobParameterInfo.setDescription((String)((ArrayList)object5).get(4));
                arrayList2.add(jobParameterInfo);
            }
            jobInfo.setParam(arrayList2);
        }
        return jobInfo;
    }

    protected void registerJob(JobTreeItem jobTreeItem) {
        log.info((Object)Messages.getMsg("ImportTool.Job.Register.Start"));
        JobController jobController = EjbConnectionManager.getConnectionManager().getJobController();
        try {
            jobController.registerJob(jobTreeItem);
        }
        catch (Exception exception) {
            log.error((Object)Messages.getMsg("ExportTool.ConnectManagerFailed"), (Throwable)exception);
            System.exit(14);
        }
        log.info((Object)Messages.getMsg("ImportTool.Job.Register.End"));
    }
}

