/*
 * Decompiled with CFR 0.152.
 */
package jp.co.intellilink.hinemos.importtool.conf.monitor;

import com.clustercontrol.bean.ConvertValueConstant;
import com.clustercontrol.monitor.run.bean.MonitorCheckInfo;
import com.clustercontrol.monitor.run.bean.MonitorInfo;
import com.clustercontrol.snmp.bean.MonitorSnmpInfo;
import com.clustercontrol.snmp.ejb.session.MonitorSnmpController;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.ejb.DuplicateKeyException;
import jp.co.intellilink.hinemos.importtool.conf.monitor.ImportMonitorNumeric;
import jp.co.intellilink.hinemos.importtool.util.Config;
import jp.co.intellilink.hinemos.importtool.util.EjbConnectionManager;
import jp.co.intellilink.hinemos.importtool.util.Messages;
import jp.co.intellilink.hinemos.importtool.util.ReadCsvFile;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImportMonitorSnmp
extends ImportMonitorNumeric {
    private static Log log = LogFactory.getLog(ImportMonitorSnmp.class);
    private ArrayList monitorList = null;
    private ArrayList<ArrayList<String>> monitorInfos = null;

    public void importSnmp() {
        log.info((Object)Messages.getMsg("ImportTool.Snmp.Start"));
        this.monitorInfos = ReadCsvFile.readCsvFile(Config.getConfig("Input.Dir.Conf") + "/SNMP.csv");
        this.monitorList = this.getMonitorList();
        for (ArrayList<String> arrayList : this.monitorInfos) {
            MonitorInfo monitorInfo = this.createMonitorInfo(arrayList);
            this.registerMonitorInfo(monitorInfo);
        }
        log.info((Object)Messages.getMsg("ImportTool.Snmp.End"));
    }

    @Override
    protected MonitorInfo createMonitorInfo(ArrayList<String> arrayList) {
        MonitorInfo monitorInfo = new MonitorInfo();
        this.createMonitorBase(arrayList, monitorInfo);
        this.createMonitorRule(arrayList.subList(3, 5), monitorInfo);
        this.createMonitorCheck(arrayList.subList(5, 10), monitorInfo);
        this.createMonitorBlock(arrayList.subList(10, 11), monitorInfo);
        this.createMonitorJudgement(arrayList.subList(11, 16), monitorInfo);
        this.createMonitorNotify(arrayList.subList(16, 21), monitorInfo);
        this.createMonitorApplication(arrayList.subList(21, 22), monitorInfo);
        this.createMonitorVaild(arrayList.subList(22, 23), monitorInfo);
        return monitorInfo;
    }

    @Override
    protected void createMonitorCheck(List<String> list, MonitorInfo monitorInfo) {
        MonitorSnmpInfo monitorSnmpInfo = new MonitorSnmpInfo();
        monitorSnmpInfo.setCommunityName(list.get(0));
        monitorSnmpInfo.setSnmpPort(Integer.valueOf(Integer.parseInt(list.get(1))));
        monitorSnmpInfo.setSnmpOid(list.get(2));
        monitorSnmpInfo.setSnmpVersion(list.get(3));
        monitorSnmpInfo.setConvertFlg(Integer.valueOf(ConvertValueConstant.stringToType((String)list.get(4))));
        monitorInfo.setCheckInfo((MonitorCheckInfo)monitorSnmpInfo);
        monitorInfo.setMonitorType(1);
        super.createMonitorCheck(list, monitorInfo);
    }

    protected void registerMonitorInfo(MonitorInfo monitorInfo) {
        MonitorSnmpController monitorSnmpController = EjbConnectionManager.getConnectionManager().getMonitorSnmpController();
        try {
            ArrayList arrayList = this.checkMonitorList(monitorInfo.getMonitorId(), this.monitorList);
            if (arrayList instanceof ArrayList) {
                Date date = (Date)arrayList.get(8);
                String string = (String)arrayList.get(7);
                monitorInfo.setRegDate(new Timestamp(date.getTime()));
                monitorInfo.setRegUser(string);
                Object[] objectArray = new Object[]{monitorInfo.getMonitorId()};
                log.info((Object)(Messages.getMsg("ImportTool.MonitorID", objectArray) + " (" + Messages.getMsg("modify") + ")"));
                monitorSnmpController.modifySnmp(monitorInfo);
            } else {
                Object[] objectArray = new Object[]{monitorInfo.getMonitorId()};
                log.info((Object)(Messages.getMsg("ImportTool.MonitorID", objectArray) + " (" + Messages.getMsg("add") + ")"));
                monitorSnmpController.addSnmp(monitorInfo);
            }
        }
        catch (DuplicateKeyException duplicateKeyException) {
            Object[] objectArray = new String[]{monitorInfo.getMonitorId()};
            log.error((Object)Messages.getMsg("ImportTool.Common.1", objectArray));
            System.exit(20);
        }
        catch (Exception exception) {
            log.error((Object)Messages.getMsg("ImportTool.ConnectManagerFailed"), (Throwable)exception);
            System.exit(14);
        }
    }

    protected ArrayList getMonitorList() {
        MonitorSnmpController monitorSnmpController = EjbConnectionManager.getConnectionManager().getMonitorSnmpController();
        ArrayList arrayList = null;
        try {
            arrayList = monitorSnmpController.getSnmpList();
        }
        catch (Exception exception) {
            log.error((Object)Messages.getMsg("ImportTool.ConnectManagerFailed"), (Throwable)exception);
            System.exit(14);
        }
        return arrayList;
    }
}

