/*
 * Decompiled with CFR 0.152.
 */
package jp.co.dgic.eclipse.jdt.internal.coverage.report;

import jp.co.dgic.eclipse.jdt.internal.coverage.ui.CoverageReportView;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class PageNavigation
extends Canvas {
    private static final RGB RGB_BACKGROUND = new RGB(255, 255, 255);
    private static final RGB RGB_FOREGROUND = new RGB(0, 0, 0);
    private static final RGB RGB_CURRENT_FOREGROUND = new RGB(0, 0, 255);
    private static final FontData FONT_PAGE_NUMBER = new FontData("Courier New", 14, 1);
    private int currentPage = 0;
    private int maxPage = 0;
    private CoverageReportView reportView = null;

    public PageNavigation(CoverageReportView reportView, int currentPage, int maxPage) {
        super((Composite)reportView.getReportCanvas(), 0);
        this.reportView = reportView;
        this.currentPage = currentPage;
        this.maxPage = maxPage;
        GridLayout gl = new GridLayout(maxPage + 2, false);
        gl.verticalSpacing = 0;
        gl.horizontalSpacing = 0;
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        this.setLayout((Layout)gl);
        this.setBackground(new Color((Device)this.getDisplay(), RGB_BACKGROUND));
        this.buildButtons();
    }

    private void buildButtons() {
        Button prevButton = new Button((Composite)this, 0x804004);
        prevButton.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                PageNavigation.this.reportView.prevPage();
            }
        });
        if (this.currentPage == 1) {
            prevButton.setVisible(false);
        }
        PageNumberLabel pageLabel = null;
        int i = 1;
        while (i <= this.maxPage) {
            pageLabel = new PageNumberLabel((Composite)this);
            pageLabel.setPageNumber(i);
            pageLabel.setCurrent(i == this.currentPage);
            ++i;
        }
        Button nextButton = new Button((Composite)this, 8519684);
        nextButton.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                PageNavigation.this.reportView.nextPage();
            }
        });
        if (this.currentPage == this.maxPage) {
            nextButton.setVisible(false);
        }
    }

    private class PageNumberLabel
    extends Label {
        private int pageNumber = 0;

        public PageNumberLabel(Composite parent) {
            super(parent, 0);
            this.setBackground(new Color((Device)this.getDisplay(), RGB_BACKGROUND));
            this.setForeground(new Color((Device)this.getDisplay(), RGB_FOREGROUND));
            this.setFont(new Font((Device)this.getDisplay(), FONT_PAGE_NUMBER));
        }

        public void setPageNumber(int pageNumber) {
            this.pageNumber = pageNumber;
            this.setText(" " + pageNumber + " ");
        }

        public void setCurrent(boolean isCurrent) {
            if (isCurrent) {
                this.setForeground(new Color((Device)this.getDisplay(), RGB_CURRENT_FOREGROUND));
                return;
            }
            this.addMouseListener((MouseListener)new MouseAdapter(this){
                final /* synthetic */ PageNumberLabel this$1;
                {
                    this.this$1 = pageNumberLabel;
                }

                public void mouseDown(MouseEvent e) {
                    PageNavigation.access$4(PageNumberLabel.access$1(this.this$1)).movePage(PageNumberLabel.access$0(this.this$1));
                }
            });
            this.addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(this){
                final /* synthetic */ PageNumberLabel this$1;
                {
                    this.this$1 = pageNumberLabel;
                }

                public void mouseEnter(MouseEvent e) {
                    this.this$1.setCursor(new Cursor((Device)this.this$1.getDisplay(), 21));
                }

                public void mouseExit(MouseEvent e) {
                    this.this$1.setCursor(new Cursor((Device)this.this$1.getDisplay(), 0));
                }
            });
        }

        protected void checkSubclass() {
        }

        static /* synthetic */ int access$0(PageNumberLabel pageNumberLabel) {
            return pageNumberLabel.pageNumber;
        }

        static /* synthetic */ PageNavigation access$1(PageNumberLabel pageNumberLabel) {
            return pageNumberLabel.PageNavigation.this;
        }
    }
}

