/*

Copyright (C) 2009 NTT DATA INTELLILINK CORPORATION

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.

 */

package jp.co.intellilink.hinemos.importtool.util;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * CSVファイル読み込みクラス<br>
 * 
 * @version 1.1.0
 * @since 1.1.0
 */
public class ReadCsvFile {

	// ログ出力
	private static Log log = LogFactory.getLog(ReadCsvFile.class);

	/**
	 * CSVファイルを読み込む。<br>
	 * 
	 * @param filePath CSVファイルのファイルパス
	 * @return 格納配列
	 */
	public static ArrayList<ArrayList<String>> readCsvFile(String filePath) {

		// ファイル読み込み用変数
		BufferedReader br = null;
		ArrayList<ArrayList<String>> input = new ArrayList<ArrayList<String>>();

		// CSVファイルから読み込み
		try {
			// ファイルを開く
			br = new BufferedReader(new FileReader(filePath));

			StringBuffer conf = new StringBuffer();
			String line = "";
			while ((line = br.readLine()) != null) {
				if(conf.length() > 0)
					conf.append("\n");
				conf.append(line);
				
				int index = 0;
				int count = 0;
				while((index = conf.toString().indexOf("\"", index + 1)) != -1){
					count++;
				}
				if((count % 2) == 0){
					String[] elements = conf.toString().split("\t");
					ArrayList<String> inputLine = new ArrayList<String>();
					for(String element : elements){
						inputLine.add(element.replaceFirst("^\"", "").replaceFirst("\"$", ""));
					}
					input.add(inputLine);
					
					conf = new StringBuffer();
				}
			}

		} catch (Exception e) {
			// ファイルの読み込み処理に失敗した場合
			log.error(Messages.getMsg("ImportTool.ReadFileFailed"), e);
			System.exit(51);
		} finally {
			try {
				// ファイルを閉じる
				if (br != null) {
					br.close();
				}
			} catch (IOException e) {
				// ファイルの読み込み処理に失敗した場合
				log.error(Messages.getMsg("ImportTool.ReadFileFailed"), e);
				System.exit(51);
			}
		}

		return input;
	}
}
