/*
 
Copyright (C) 2009 NTT DATA INTELLILINK CORPORATION
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package jp.co.intellilink.operation.logger.util;

import java.security.Principal;

import org.jboss.security.SecurityAssociation;

/**
 * ユーザ名用ログメッセージ生成クラス
 * 
 * @since 1.0.0
 * @version 1.0.0
 */
public class UserName extends LogMessageDecorator {

	/**
	 * コンストラクタ
	 * 
	 * @param component LogMessageComponentオブジェクト
	 */
	public UserName(LogMessageComponent component) {
		super(component);
	}

	/**
	 * ユーザ名を取得し、ログメッセージを作成する
	 * 
	 * @return ログメッセージ
	 * @see jp.co.intellilink.operation.logger.util.LogMessageDecorator#getLogMessage()
	 */
	@Override
	public String getLogMessage() throws Exception {
		String name = ", User=";
		try {
			Principal pri = SecurityAssociation.getCallerPrincipal();
			if(pri instanceof Principal)
				name = name + pri.getName();

		} catch (Exception e) {
			throw e;
		}
		return name + super.getLogMessage();
	}
}
