/*
 
Copyright (C) 2009 NTT DATA INTELLILINK CORPORATION
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package jp.co.intellilink.operation.logger.util;

import org.jboss.aop.joinpoint.MethodInvocation;

/**
 * ログメッセージ生成Componentクラス
 * 
 * @since 1.0.0
 * @version 1.0.0
 */
public abstract class LogMessageComponent {

	/**
	 * 値設定
	 * @param invocation MethodInvocationオブジェクト
	 */
	public abstract void setValue(MethodInvocation invocation);


	/**
	 * 値取得
	 * 
	 * @return MethodInvocationオブジェクト
	 */
	public abstract MethodInvocation getValue();

	/**
	 * ログメッセージ取得
	 * 
	 * @return ログメッセージ
	 * @throws Exception
	 */
	public abstract String getLogMessage() throws Exception;
}
