/*
 
Copyright (C) 2009 NTT DATA INTELLILINK CORPORATION
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package jp.co.intellilink.operation.logger.util;

/**
 * メソッド名用ログメッセージ生成クラス
 * 
 * @since 1.0.0
 * @version 1.0.0
 */
public class MethodName extends LogMessageDecorator {

	/**
	 * コンストラクタ
	 * 
	 * @param component LogMessageComponentオブジェクト
	 */
	public MethodName(LogMessageComponent component) {
		super(component);
	}

	/**
	 * MethodInvocationからメソッド名を取得し、ログメッセージを作成する
	 * 
	 * @return ログメッセージ
	 * @see jp.co.intellilink.operation.logger.util.LogMessageDecorator#getLogMessage()
	 */
	@Override
	public String getLogMessage() throws Exception {
		String name = ", Method=";
		try {
			name = name + getValue().getMethod().getName();
		} catch (Exception e) {
			throw e;
		}
		return name + super.getLogMessage();
	}
}
