/*
 
Copyright (C) 2008 NTT DATA INTELLILINK CORPORATION
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package jp.co.intellilink.hinemos.test.monitor.process;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;

import jp.co.intellilink.hinemos.test.monitor.CheckResultMonitor;
import jp.co.intellilink.hinemos.test.util.Config;
import jp.co.intellilink.hinemos.test.util.EjbConnectionManager;
import jp.co.intellilink.hinemos.test.util.Messages;
import jp.co.intellilink.hinemos.test.util.StringListComparator;
import jp.co.intellilink.hinemos.test.util.WriteCsvFile;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.monitor.run.bean.MonitorInfo;
import com.clustercontrol.process.ejb.session.MonitorProcessController;

/**
 * プロセス監視結果をチェックするクラス<br>
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class CheckResultMonitorProcess extends CheckResultMonitor {

	// ログ出力
	private static Log log = LogFactory.getLog(CheckResultMonitorProcess.class);
	
	public CheckResultMonitorProcess(Date fromDate) {
		super(fromDate);
	}
	
	/**
     * プロセス監視情報を基に監視結果をチェックする。<br>
     */
    public void checkResult() {
    	log.info("[" + Messages.getMsg("CheckResult")+ "] " + Messages.getMsg("TestTool.Process.Start"));
    	
    	//CSV出力配列を用意
    	ArrayList<ArrayList<String>> csvOutput = new ArrayList<ArrayList<String>>();
    	
    	//監視項目リスト取得
    	ArrayList idList = getProcessList();
    	
    	if(idList instanceof ArrayList){
			Iterator itr = idList.iterator();
			while(itr.hasNext()){
				ArrayList line = (ArrayList)itr.next();
				
				Object[] args = {(String)line.get(0)};
				log.info("[" + Messages.getMsg("CheckResult")+ "] " + Messages.getMsg("TestTool.MonitorID", args));
				
				MonitorInfo info = getProcess((String)line.get(0));
				csvOutput.addAll(createCheckResult(info));
			}
			
			//ファシリティIDでソート
			Collections.sort(csvOutput, new StringListComparator(1));
			//監視項目IDでソート
			Collections.sort(csvOutput, new StringListComparator(0));
    	}
    	
		SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd_HHmmss");
		
		WriteCsvFile.writeCsvFile(
				Config.getConfig("Check.Output.Dir") + "/PROCESS_" + format.format(new Date()) + ".csv", 
				csvOutput);
		
		log.info("[" + Messages.getMsg("CheckResult")+ "] " + Messages.getMsg("TestTool.Process.End"));
    }

    /**
     * プロセス監視情報を取得する。<br>
     * 
     * @param monitorId 取得対象の監視項目ID
     * @return プロセス監視情報
     */
    protected MonitorInfo getProcess(String monitorId) {

        MonitorProcessController process = EjbConnectionManager.getConnectionManager().getMonitorProcessController();

        MonitorInfo info = null;
        try {
        	info = process.getProcess(monitorId);
        } catch (Exception e) {
			log.error("[" + Messages.getMsg("CheckResult")+ "] " + Messages.getMsg("TestTool.ConnectManagerFailed"), e);
			System.exit(14);
        }
        return info;
    }
    
    /**
     * 監視項目リストを取得する。<br>
     * 
     * @return 監視項目一覧
     */
    protected ArrayList getProcessList() {

    	MonitorProcessController process = EjbConnectionManager.getConnectionManager().getMonitorProcessController();

    	ArrayList records = null;
    	try {
    		records = process.getProcessList();
        } catch (Exception e) {
			log.error("[" + Messages.getMsg("CheckResult")+ "] " + Messages.getMsg("TestTool.ConnectManagerFailed"), e);
			System.exit(14);
        }
        return records;
    }
}