/*
 
Copyright (C) 2008 NTT DATA INTELLILINK CORPORATION
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package jp.co.intellilink.hinemos.test;

import java.text.DateFormat;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Date;

import javax.naming.NamingException;

import jp.co.intellilink.hinemos.test.logtransfer.CheckResultLogTransfer;
import jp.co.intellilink.hinemos.test.maintenance.CheckResultMaintenamce;
import jp.co.intellilink.hinemos.test.monitor.agent.CheckResultMonitorAgent;
import jp.co.intellilink.hinemos.test.monitor.http.CheckResultMonitorHttp;
import jp.co.intellilink.hinemos.test.monitor.performance.CheckResultMonitorPerformance;
import jp.co.intellilink.hinemos.test.monitor.ping.CheckResultMonitorPing;
import jp.co.intellilink.hinemos.test.monitor.port.CheckResultMonitorPort;
import jp.co.intellilink.hinemos.test.monitor.process.CheckResultMonitorProcess;
import jp.co.intellilink.hinemos.test.monitor.snmp.CheckResultMonitorSnmp;
import jp.co.intellilink.hinemos.test.monitor.snmptrap.CheckResultMonitorSnmpTrap;
import jp.co.intellilink.hinemos.test.monitor.sql.CheckResultMonitorSql;
import jp.co.intellilink.hinemos.test.monitor.syslogng.CheckResultMonitorSyslogng;
import jp.co.intellilink.hinemos.test.performance.CheckResultPerformance;
import jp.co.intellilink.hinemos.test.util.LoginManager;
import jp.co.intellilink.hinemos.test.util.Messages;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * CheckResult メインクラス<br>
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class CheckResult {
	// 動作モード
	private static String mode = "all";
	// イベント情報チェック開始日時
	private static Date startDate = null;
	
	// ログ出力
	private static Log log = LogFactory.getLog(CheckResult.class);
	
	/**
	 * メイン
	 * 
	 * @param args
	 */
	public static void main(String[] args) {
		
		// 実行ログを記載
		log.info("[" + Messages.getMsg("CheckResult")+ "] " + Messages.getMsg("TestTool.Exec") + " : " + Arrays.toString(args));

		// 引数の数の確認
		if (args.length > 2) {
			log.error("[" + Messages.getMsg("CheckResult")+ "] " + Messages.getMsg("TestTool.CheckResult.ArgsInvalid"));
			System.exit(11);
		}

		// 引数の格納
		if(args.length == 0 || args[0].equals(""))
			mode = "all";
		else if(args.length >= 1)
			mode = args[0];
		
		if(args.length == 2){
			try {
				startDate = DateFormat.getDateTimeInstance().parse(args[1]);
			} catch (ParseException e) {
				try {
					startDate = DateFormat.getDateInstance().parse(args[1]);
				} catch (ParseException e1) {
					startDate = null;
				}
			}
		}
		
		if(mode.equalsIgnoreCase("log") || mode.equalsIgnoreCase("all")){
			//ログ転送機能
			CheckResultLogTransfer logTransfer = new CheckResultLogTransfer(startDate);
			logTransfer.checkResult();
		}
		if(mode.equalsIgnoreCase("mainte") || mode.equalsIgnoreCase("all")){
			//メンテナンス機能
			CheckResultMaintenamce maintenance = new CheckResultMaintenamce(startDate);
			maintenance.checkResult();
		}
		if(mode.equalsIgnoreCase("ping") || mode.equalsIgnoreCase("all")){
			//Ping監視
			CheckResultMonitorPing ping = new CheckResultMonitorPing(startDate);
			ping.checkResult();
		}
		if(mode.equalsIgnoreCase("agent") || mode.equalsIgnoreCase("all")){
			//エージェント監視
			CheckResultMonitorAgent agent = new CheckResultMonitorAgent(startDate);
			agent.checkResult();
		}
		if(mode.equalsIgnoreCase("process") || mode.equalsIgnoreCase("all")){
			//プロセス監視
			CheckResultMonitorProcess process = new CheckResultMonitorProcess(startDate);
			process.checkResult();
		}
		if(mode.equalsIgnoreCase("resource") || mode.equalsIgnoreCase("all")){
			//リソース監視
			CheckResultMonitorPerformance perf = new CheckResultMonitorPerformance(startDate);
			perf.checkResult();
		}
		if(mode.equalsIgnoreCase("perf") || mode.equalsIgnoreCase("all")){
			//性能管理機能の実績収集
			CheckResultPerformance performance = new CheckResultPerformance();
			performance.checkResult();
		}
		if(mode.equalsIgnoreCase("syslog") || mode.equalsIgnoreCase("all")){
			//syslog-ng監視
			CheckResultMonitorSyslogng syslog = new CheckResultMonitorSyslogng(startDate);
			syslog.checkResult();
		}
		if(mode.equalsIgnoreCase("snmp") || mode.equalsIgnoreCase("all")){
			//SNMP監視
			CheckResultMonitorSnmp snmp = new CheckResultMonitorSnmp(startDate);
			snmp.checkResult();
		}
		if(mode.equalsIgnoreCase("trap") || mode.equalsIgnoreCase("all")){
			//SNMPTRAP監視
			CheckResultMonitorSnmpTrap trap = new CheckResultMonitorSnmpTrap(startDate);
			trap.checkResult();
		}
		if(mode.equalsIgnoreCase("port") || mode.equalsIgnoreCase("all")){
			//サービス・ポート監視
			CheckResultMonitorPort port = new CheckResultMonitorPort(startDate);
			port.checkResult();
		}
		if(mode.equalsIgnoreCase("http") || mode.equalsIgnoreCase("all")){
			//HTTP監視
			CheckResultMonitorHttp http = new CheckResultMonitorHttp(startDate);
			http.checkResult();
		}
		if(mode.equalsIgnoreCase("sql") || mode.equalsIgnoreCase("all")){
			//SQL監視
			CheckResultMonitorSql sql = new CheckResultMonitorSql(startDate);
			sql.checkResult();
		}
//		else{
//			log.error(Messages.getMsg("TestTool.ModeNotFound"));
//			System.exit(12);
//		}
		
		// マネージャー接続の切断
		try {
			LoginManager.getContextManager().logout();
		} catch (NamingException e) {
			log.warn("[" + Messages.getMsg("CheckResult")+ "] " + Messages.getMsg("TestTool.DisconnectManagerFailed"), e);
		}
		
		// 正常終了
		log.info("[" + Messages.getMsg("CheckResult")+ "] " + Messages.getMsg("TestTool.Exit"));
		System.exit(0);
	}
}
