/*
 
Copyright (C) 2008 NTT DATA INTELLILINK CORPORATION
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package jp.co.intellilink.hinemos.test;

import java.util.Arrays;

import javax.naming.NamingException;

import jp.co.intellilink.hinemos.test.job.ExportTestCaseJob;
import jp.co.intellilink.hinemos.test.job.ExportTestCaseSchedule;
import jp.co.intellilink.hinemos.test.logtransfer.ExportTestCaseLogTransfer;
import jp.co.intellilink.hinemos.test.maintenance.ExportTestCaseMaintenamce;
import jp.co.intellilink.hinemos.test.monitor.agent.ExportTestCaseMonitorAgent;
import jp.co.intellilink.hinemos.test.monitor.http.ExportTestCaseMonitorHttp;
import jp.co.intellilink.hinemos.test.monitor.performance.ExportTestCaseMonitorPerformance;
import jp.co.intellilink.hinemos.test.monitor.ping.ExportTestCaseMonitorPing;
import jp.co.intellilink.hinemos.test.monitor.port.ExportTestCaseMonitorPort;
import jp.co.intellilink.hinemos.test.monitor.process.ExportTestCaseMonitorProcess;
import jp.co.intellilink.hinemos.test.monitor.snmp.ExportTestCaseMonitorSnmp;
import jp.co.intellilink.hinemos.test.monitor.snmptrap.ExportTestCaseMonitorSnmpTrap;
import jp.co.intellilink.hinemos.test.monitor.sql.ExportTestCaseMonitorSql;
import jp.co.intellilink.hinemos.test.monitor.syslogng.ExportTestCaseMonitorSyslogng;
import jp.co.intellilink.hinemos.test.performance.ExportTestCasePerformance;
import jp.co.intellilink.hinemos.test.util.LoginManager;
import jp.co.intellilink.hinemos.test.util.Messages;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * ExportTestCase メインクラス<br>
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class ExportTestCase {
	// 動作モード
	private static String mode = "all";
	
	// ログ出力
	private static Log log = LogFactory.getLog(ExportTestCase.class);
	
	/**
	 * メイン
	 * 
	 * @param args
	 */
	public static void main(String[] args) {
		
		// 実行ログを記載
		log.info("[" + Messages.getMsg("ExportTestCase")+ "] " + Messages.getMsg("TestTool.Exec") + " : " + Arrays.toString(args));

		// 引数の数の確認
		if (args.length > 1) {
			log.error("[" + Messages.getMsg("ExportTestCase")+ "] " + Messages.getMsg("TestTool.ExportTestCase.ArgsInvalid"));
			System.exit(11);
		}

		// 引数の格納
		if(args.length == 0 || args[0].equals(""))
			mode = "all";
		else if(args.length >= 1)
			mode = args[0];
		
		if(mode.equalsIgnoreCase("log") || mode.equalsIgnoreCase("all")){
			//ログ転送機能
			ExportTestCaseLogTransfer logTransfer = new ExportTestCaseLogTransfer();
			logTransfer.exportTestCase();
		}
		if(mode.equalsIgnoreCase("mainte") || mode.equalsIgnoreCase("all")){
			//メンテナンス機能
			ExportTestCaseMaintenamce maintenance = new ExportTestCaseMaintenamce();
			maintenance.exportTestCase();
		}
		if(mode.equalsIgnoreCase("ping") || mode.equalsIgnoreCase("all")){
			//Ping監視
			ExportTestCaseMonitorPing ping = new ExportTestCaseMonitorPing();
			ping.exportTestCase();
		}
		if(mode.equalsIgnoreCase("agent") || mode.equalsIgnoreCase("all")){
			//エージェント監視
			ExportTestCaseMonitorAgent agent = new ExportTestCaseMonitorAgent();
			agent.exportTestCase();
		}
		if(mode.equalsIgnoreCase("process") || mode.equalsIgnoreCase("all")){
			//プロセス監視
			ExportTestCaseMonitorProcess process = new ExportTestCaseMonitorProcess();
			process.exportTestCase();
		}
		if(mode.equalsIgnoreCase("resource") || mode.equalsIgnoreCase("all")){
			//リソース監視
			ExportTestCaseMonitorPerformance perf = new ExportTestCaseMonitorPerformance();
			perf.exportTestCase();
		}
		if(mode.equalsIgnoreCase("perf") || mode.equalsIgnoreCase("all")){
			//性能管理機能の実績収集
			ExportTestCasePerformance performance = new ExportTestCasePerformance();
			performance.exportTestCase();
		}
		if(mode.equalsIgnoreCase("syslog") || mode.equalsIgnoreCase("all")){
			//syslog-ng監視
			ExportTestCaseMonitorSyslogng syslog = new ExportTestCaseMonitorSyslogng();
			syslog.exportTestCase();
		}
		if(mode.equalsIgnoreCase("snmp") || mode.equalsIgnoreCase("all")){
			//SNMP監視
			ExportTestCaseMonitorSnmp snmp = new ExportTestCaseMonitorSnmp();
			snmp.exportTestCase();
		}
		if(mode.equalsIgnoreCase("trap") || mode.equalsIgnoreCase("all")){
			//SNMPTRAP監視
			ExportTestCaseMonitorSnmpTrap trap = new ExportTestCaseMonitorSnmpTrap();
			trap.exportTestCase();
		}
		if(mode.equalsIgnoreCase("port") || mode.equalsIgnoreCase("all")){
			//サービス・ポート監視
			ExportTestCaseMonitorPort port = new ExportTestCaseMonitorPort();
			port.exportTestCase();
		}
		if(mode.equalsIgnoreCase("http") || mode.equalsIgnoreCase("all")){
			//HTTP監視
			ExportTestCaseMonitorHttp http = new ExportTestCaseMonitorHttp();
			http.exportTestCase();
		}
		if(mode.equalsIgnoreCase("sql") || mode.equalsIgnoreCase("all")){
			//SQL監視
			ExportTestCaseMonitorSql sql = new ExportTestCaseMonitorSql();
			sql.exportTestCase();
		}
		if(mode.equalsIgnoreCase("job") || mode.equalsIgnoreCase("all")){
			//ジョブ
			ExportTestCaseJob job = new ExportTestCaseJob();
			job.exportTestCase();
			//ジョブスケジュール
			ExportTestCaseSchedule sche = new ExportTestCaseSchedule();
			sche.exportTestCase();
		}
//		else{
//			log.error(Messages.getMsg("TestTool.ModeNotFound"));
//			System.exit(12);
//		}
		
		// マネージャー接続の切断
		try {
			LoginManager.getContextManager().logout();
		} catch (NamingException e) {
			log.warn("[" + Messages.getMsg("ExportTestCase")+ "] " + Messages.getMsg("TestTool.DisconnectManagerFailed"), e);
		}
		
		// 正常終了
		log.info("[" + Messages.getMsg("ExportTestCase")+ "] " + Messages.getMsg("TestTool.Exit"));
		System.exit(0);
	}
}
