/*

Copyright (C) 2008 NTT DATA INTELLILINK CORPORATION

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.

 */

package jp.co.intellilink.hinemos.test.monitor.http;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;

import jp.co.intellilink.hinemos.test.monitor.CheckResultMonitor;
import jp.co.intellilink.hinemos.test.util.Config;
import jp.co.intellilink.hinemos.test.util.EjbConnectionManager;
import jp.co.intellilink.hinemos.test.util.Messages;
import jp.co.intellilink.hinemos.test.util.StringListComparator;
import jp.co.intellilink.hinemos.test.util.WriteCsvFile;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.http.ejb.session.MonitorHttpController;
import com.clustercontrol.monitor.run.bean.MonitorInfo;
import com.clustercontrol.monitor.run.bean.MonitorTypeConstant;

/**
 * HTTP監視結果をチェックするクラス<br>
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class CheckResultMonitorHttp extends CheckResultMonitor {

	// ログ出力
	private static Log log = LogFactory.getLog(CheckResultMonitorHttp.class);

	public CheckResultMonitorHttp(Date fromDate, Date toDate) {
		super(fromDate, toDate);
	}

	/**
	 * HTTP監視情報を基に監視結果をチェックする。<br>
	 */
	public void checkResult() {
		log.info("[" + Messages.getMsg("CheckResult")+ "] " + Messages.getMsg("TestTool.Http.Start"));

		//CSV出力配列を用意
		ArrayList<ArrayList<String>> csvOutput = new ArrayList<ArrayList<String>>();

		//監視項目リスト取得
		ArrayList idList = getHttpList();

		if(idList instanceof ArrayList){
			Iterator itr = idList.iterator();
			while(itr.hasNext()){
				MonitorInfo info = (MonitorInfo)itr.next();

				if(info.getMonitorType() == MonitorTypeConstant.TYPE_NUMERIC){
					Object[] args = {info.getMonitorId()};
					log.info("[" + Messages.getMsg("CheckResult")+ "] " + Messages.getMsg("TestTool.MonitorID", args));

					csvOutput.addAll(createCheckResult(info));
				}
			}

			//ファシリティIDでソート
			Collections.sort(csvOutput, new StringListComparator(1));
			//監視項目IDでソート
			Collections.sort(csvOutput, new StringListComparator(0));
		}

		SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd_HHmmss");

		WriteCsvFile.writeCsvFile(
				Config.getConfig("Check.Output.Dir") + "/HTTP_" + format.format(new Date()) + ".csv", 
				csvOutput);

		log.info("[" + Messages.getMsg("CheckResult")+ "] " + Messages.getMsg("TestTool.Http.End"));
	}

	/**
	 * 監視項目リストを取得する。<br>
	 * 
	 * @return 監視項目一覧
	 */
	protected ArrayList getHttpList() {

		MonitorHttpController http = EjbConnectionManager.getConnectionManager().getMonitorHttpController();

		ArrayList records = null;
		try {
			records = http.getHttpList();
		} catch (Exception e) {
			log.error("[" + Messages.getMsg("CheckResult")+ "] " + Messages.getMsg("TestTool.ConnectManagerFailed"), e);
			System.exit(14);
		}
		return records;
	}
}