<?php
	// Copyright (c) 2008, u6k.yu1@gmail.com
	// All rights reserved.
	// 
	// Redistribution and use in source and binary forms, with or without
	// modification, are permitted provided that the following conditions are met:
	//     * Redistributions of source code must retain the above copyright
	//       notice, this list of conditions and the following disclaimer.
	//     * Redistributions in binary form must reproduce the above copyright
	//       notice, this list of conditions and the following disclaimer in the
	//       documentation and/or other materials provided with the distribution.
	//     * Neither the name of the u6k nor the
	//       names of its contributors may be used to endorse or promote products
	//       derived from this software without specific prior written permission.
	// 
	// THIS SOFTWARE IS PROVIDED BY u6k.yu1@gmail.com ``AS IS'' AND ANY
	// EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
	// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
	// DISCLAIMED. IN NO EVENT SHALL u6k.yu1@gmail.com BE LIABLE FOR ANY
	// DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
	// (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
	// LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
	// ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
	// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
	// SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
	
	require_once(dirname(__FILE__) . "/common/common.php");
	require_once(dirname(__FILE__) . "/logic/Hirameki_ArticleLogic.php");
	
	$article_list = Hirameki_ArticleLogic::findByAll();
	
	Hirameki_HtmlUtil::headerContentType();
	
	$page_title = "記事の一覧";
	require_once("page_header.php");
?>
		<table id="article_list" border="1">
			<tr>
				<th>ID</th>
				<th>件名</th>
				<th>更新日時</th>
				<th>更新者</th>
				<th>作成日時</th>
				<th>作成者</th>
				<th>タグ</th>
			</tr>
<?php
	foreach ($article_list as $i => $article) {
?>
			<tr class="<?php if ($i % 2 == 0) { print("list_even"); } else { print("list_odd"); } ?>">
				<td><a href="article_detail.php?id=<?php Hirameki_HtmlUtil::printInt($article["id"]); ?>"><?php Hirameki_HtmlUtil::printInt($article["id"]); ?></a></td>
				<td><a href="article_detail.php?id=<?php Hirameki_HtmlUtil::printInt($article["id"]); ?>"><?php Hirameki_HtmlUtil::printStr($article["title"]); ?></a></td>
				<td><?php Hirameki_HtmlUtil::printTime($article["update_time"]); ?></td>
				<td><?php Hirameki_HtmlUtil::printStr($article["update_account_name"]); ?></td>
				<td><?php Hirameki_HtmlUtil::printTime($article["create_time"]); ?></td>
				<td><?php Hirameki_HtmlUtil::printStr($article["create_account_name"]); ?></td>
				<td><?php Hirameki_HtmlUtil::printStr($article["tag"]); ?></td>
			</tr>
<?php
	}
?>
		</table>
<?php
	require_once("page_footer.php");
?>
