<?php
	// Copyright (c) 2008, u6k.yu1@gmail.com
	// All rights reserved.
	// 
	// Redistribution and use in source and binary forms, with or without
	// modification, are permitted provided that the following conditions are met:
	//     * Redistributions of source code must retain the above copyright
	//       notice, this list of conditions and the following disclaimer.
	//     * Redistributions in binary form must reproduce the above copyright
	//       notice, this list of conditions and the following disclaimer in the
	//       documentation and/or other materials provided with the distribution.
	//     * Neither the name of the u6k nor the
	//       names of its contributors may be used to endorse or promote products
	//       derived from this software without specific prior written permission.
	// 
	// THIS SOFTWARE IS PROVIDED BY u6k.yu1@gmail.com ``AS IS'' AND ANY
	// EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
	// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
	// DISCLAIMED. IN NO EVENT SHALL u6k.yu1@gmail.com BE LIABLE FOR ANY
	// DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
	// (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
	// LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
	// ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
	// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
	// SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
	
	require_once("MDB2.php");
	
	require_once(dirname(__FILE__) . "/../common/common.php");
	
	// データベース作成の為の設定値です。
	// TODO いずれはmantisのように入力できるようにします。
	$database = "hirameki_note";
	$root_dsn = "mysqli://root:@localhost";
	$user_name = "hirameki_note";
	$user_password = "hirameki_note";
	$do_drop = FALSE;
	
	$con = MDB2::connect($root_dsn);
	
	$results = array();
	if (!$do_drop) {
		$now = dt_now();
		
		// ユーザを作成します。
		$sql = "grant all privileges on *.* to '$user_name'@localhost identified by '$user_password'";
		$sql_name = "create user";
		execute_sql($con, $sql, $sql_name, &$results);
		
		// データベースを作成します。
		$sql = "create database $database default character set utf8";
		$sql_name = "create database";
		execute_sql($con, $sql, $sql_name, &$results);
		
		$sql = "use $database";
		$sql_name = "use database";
		execute_sql($con, $sql, $sql_name, &$results);
		
		// テーブルを作成します。
		$sql = <<< SQL_END
create table article (
	id bigint not null,
	create_time bigint not null,
	enable tinyint not null,
	create_account_id bigint not null,
	title varchar(255),
	content longtext not null,
	tag varchar(255),
	primary key (id, create_time, enable)
) engine=InnoDB;
SQL_END;
		$sql_name = "create table article";
		execute_sql($con, $sql, $sql_name, &$results);
		
		$sql = <<< SQL_END
create table account (
	id bigint not null,
	create_time bigint not null,
	enable tinyint not null,
	create_account_id bigint not null,
	name varchar(255) not null,
	real_name varchar(255),
	password char(32) not null,
	email varchar(255),
	authority_group_id bigint not null,
	primary key (id, create_time, enable)
) engine=InnoDB;
SQL_END;
		$sql_name = "create table account";
		execute_sql($con, $sql, $sql_name, &$results);
		
		$sql = <<< SQL_END
create table authority_group (
	id bigint not null,
	create_time bigint not null,
	enable tinyint not null,
	name varchar(255) not null,
	need_login tinyint not null,
	can_show_article_list tinyint not null,
	can_show_article_detail tinyint not null,
	can_search_article tinyint not null,
	can_create_article tinyint not null,
	can_update_article tinyint not null,
	can_delete_article tinyint not null,
	can_create_comment tinyint not null,
	primary key (id, create_time, enable)
);
SQL_END;
		$sql_name = "create table authority_group";
		execute_sql($con, $sql, $sql_name, &$results);
		
		// データを作成します。
		$auth_group_admin_id = next_id($con, "authority_group_id", "next id authority group administrator", &$results);
		$auth_group_anony_id = next_id($con, "authority_group_id", "next id authority group anonymous", &$results);
		$auth_group_user_id = next_id($con, "authority_group_id", "next id authority group user", &$results);
		
		$sql = "insert into authority_group (id, create_time, enable, name, need_login, can_show_article_list, can_show_article_detail, can_search_article, can_create_article, can_update_article, can_delete_article, can_create_comment) values ($auth_group_admin_id, $now, 1, 'administrator', 1, 1, 1, 1, 1, 1, 1, 1)";
		$sql_name = "insert authority_group administrator";
		execute_sql($con, $sql, $sql_name, &$results);
		
		$sql = "insert into authority_group (id, create_time, enable, name, need_login, can_show_article_list, can_show_article_detail, can_search_article, can_create_article, can_update_article, can_delete_article, can_create_comment) values ($auth_group_anony_id, $now, 1, 'anonymous', 0, 1, 1, 1, 0, 0, 0, 1)";
		$sql_name = "insert authority_group anonymous";
		execute_sql($con, $sql, $sql_name, &$results);
		
		$sql = "insert into authority_group (id, create_time, enable, name, need_login, can_show_article_list, can_show_article_detail, can_search_article, can_create_article, can_update_article, can_delete_article, can_create_comment) values ($auth_group_user_id, $now, 1, 'user', 1, 1, 1, 1, 1, 1, 1, 1)";
		$sql_name = "insert authority_group user";
		execute_sql($con, $sql, $sql_name, &$results);
		
		$account_admin_id = next_id($con, "account_id", "next id account administrator", &$results);
		$account_anony_id = next_id($con, "account_id", "next id account anonymous", &$results);
		
		$sql = "insert into account (id, create_time, enable, create_account_id, name, real_name, password, email, authority_group_id) values ($account_admin_id, $now, 1, $account_admin_id, 'administrator', null, md5('administrator'), null, $auth_group_admin_id)";
		$sql_name = "insert account administrator";
		execute_sql($con, $sql, $sql_name, &$results);
		
		$sql = "insert into account (id, create_time, enable, create_account_id, name, real_name, password, email, authority_group_id) values ($account_anony_id, $now, 1, $account_admin_id, 'anonymous', 'ゲスト', md5('anonymous'), null, $auth_group_anony_id)";
		$sql_name = "insert account anonymous";
		execute_sql($con, $sql, $sql_name, &$results);
	} else {
		// データベースを削除します。
		$sql = "drop database $database";
		$sql_name = "drop database";
		execute_sql($con, $sql, $sql_name, &$results);
		
		// ユーザを削除します。
		$sql = "drop user '$user_name'@localhost";
		$sql_name = "drop user";
		execute_sql($con, $sql, $sql_name, &$results);
	}
	
	$con->disconnect();
	
	function execute_sql($con, $sql, $sql_name, $results) {
		try {
			$con->exec($sql);
			$results[$sql_name] = array("result" => TRUE, "sql" => $sql, "message" => "OK");
		} catch (Exception $err) {
			$results[$sql_name] = array("result" => FALSE, "sql" => $sql, "message" => $err->getMessage());
		}
	}
	
	function next_id($con, $sequence_name, $sql_name, $results) {
		try {
			$id = $con->nextID($sequence_name);
			$results[$sql_name] = array("result" => TRUE, "sql" => NULL, "message" => "OK");
			return $id;
		} catch (Exception $err) {
			$results[$sql_name] = array("result" => FALSE, "sql" => NULL, "message" => $err->getMessage());
		}
	}
	
	output_content_type();
	
	print("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n");
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.1//EN" "http://www.w3.org/TR/xhtml11/DTD/xhtml11.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="ja">
	<head>
		<title>MySQLデータベースの作成 - ひらめきノート</title>
	</head>
	<body>
		<table border="1">
			<tr>
				<th>タスク名</th>
				<th>結果</th>
				<th>SQL</th>
			</tr>
<?php
	foreach ($results as $sql_name => $result) {
?>
			<tr>
				<td><?php print($sql_name); ?></td>
				<td><?php print($result["message"]); ?></td>
				<td><pre><?php print($result["sql"]); ?></pre></td>
			</tr>
<?php
	}
?>
		</table>
	</body>
</html>
