/*
	$Id: SettingsForm.cs 14 2010-01-06 17:27:40Z catwalk $
*/
using System;
using System.Configuration;
using System.Windows;
using System.Windows.Data;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Interop;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Shapes;
using System.Windows.Threading;
using System.Reflection;
using System.Net;
using Hiyoko.Net.Twitter;
using Hiyoko.Net.OAuth;

namespace Hiyoko.Forms{
	using WinForms = System.Windows.Forms;
	using Gdi = System.Drawing;
	
	public partial class SettingsForm : Window{
		private ApplicationSettings tempSettings;
		private RequestToken requestToken = null;
		
		public SettingsForm(){
			this.InitializeComponent();
			
			this.tempSettings = new ApplicationSettings();
			CopySettings(Program.Settings, this.tempSettings);
			this.DataContext = this.tempSettings;
			this.twitpicPasswordEdit.Password = this.tempSettings.TwitpicPassword;
		}
		
		private void OpenStartupScriptPath(object sender, EventArgs e){
			WinForms.OpenFileDialog dlg = new WinForms.OpenFileDialog();
			dlg.Filter = "Pyt@C|*.py";
			dlg.DefaultExt = "py";
			dlg.CheckPathExists = false;
			dlg.CheckFileExists = false;
			if(dlg.ShowDialog() == WinForms.DialogResult.OK){
				this.startupScriptPathEdit.Text = dlg.FileName;
			}
		}
		
		private void OpenAuthPageClick(object sender, EventArgs e){
			try{
				this.requestToken = TwitterAPI.ObtainUnauthorizedRequestToken();
				System.Diagnostics.Process.Start(TwitterAPI.BuildUserAuthorizationURL(this.requestToken));
				this.authRequestTokenButton.IsEnabled = true;
			}catch(WebException ex){
				MessageBox.Show(ex.Message, "ʐMs", MessageBoxButton.OK, MessageBoxImage.Error);
			}
		}
		
		private void AuthRequestTokenClick(object sender, EventArgs e){
			try{
				AccessToken accessToken = TwitterAPI.GetAccessToken(this.requestToken, this.accessTokenVerifierEdit.Text);
				this.tempSettings.AccessToken = accessToken;
				MessageBox.Show("OAuthF؂܂B", "Fؐ", MessageBoxButton.OK, MessageBoxImage.Asterisk);
			}catch(WebException ex){
				MessageBox.Show(ex.Message, "F؎s", MessageBoxButton.OK, MessageBoxImage.Error);
			}
		}
		
		private void Close_CanExecute(object target, CanExecuteRoutedEventArgs e){
			e.CanExecute = true;
		}
		
		private void Close_Execute(object target, ExecutedRoutedEventArgs e){
			this.Close();
		}
		
		private void Save_CanExecute(object target, CanExecuteRoutedEventArgs e){
			e.CanExecute = true;
		}
		
		private void Save_Execute(object target, ExecutedRoutedEventArgs e){
			this.tempSettings.TwitpicPassword = this.twitpicPasswordEdit.Password;
			CopySettings(this.tempSettings, Program.Settings);
			Program.Settings.Save();
			this.Close();
		}
		
		private void Reset_CanExecute(object target, CanExecuteRoutedEventArgs e){
			e.CanExecute = true;
		}
		
		private void Reset_Execute(object target, ExecutedRoutedEventArgs e){
			if(MessageBox.Show("ݒlɖ߂Ă낵łH", "ݒ̏", MessageBoxButton.YesNo) == MessageBoxResult.Yes){
				this.tempSettings.Reset();
			}
		}
		
		private static void CopySettings(ApplicationSettingsBase source, ApplicationSettingsBase dest){
			foreach(SettingsProperty prop in source.Properties){
				dest[prop.Name] = source[prop.Name];
			}
		}
	}
}