/*
	$Id: Account.cs 14 2010-01-06 17:27:40Z catwalk $
*/
using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Diagnostics;
using System.IO;
using System.Linq;
using System.Xml.Linq;
using System.Net;
using System.Net.NetworkInformation;
using System.Text;
using System.Text.RegularExpressions;
using System.Web;
using Hiyoko.Net.OAuth;

namespace Hiyoko.Net.Twitter{
	public class Account{
		public AccessToken AccessToken{get; set;}
		
		public Account(){
		}
		
		public Account(AccessToken accessToken){
			this.AccessToken = accessToken;
		}
		
		public Collection<Status> GetHomeTimeline(int count, int page, decimal sinceId, decimal maxId){
			XElement xml;
			return this.GetHomeTimeline(count, page, sinceId, maxId, out xml);
		}
		
		public Collection<Status> GetHomeTimeline(int count, int page, decimal sinceId, decimal maxId, out XElement xml){
			Collection<Status> timeline = new Collection<Status>();
			using(HttpWebResponse res = (HttpWebResponse)TwitterAPI.GetHomeTimeline(this, count, page, sinceId, maxId).WebRequest.GetResponse())
			using(Stream stream = res.GetResponseStream()){
				string xmlString;
				using(StreamReader reader = new StreamReader(stream, Encoding.UTF8)){
					xmlString = reader.ReadToEnd();
				}
				xml = XElement.Parse(xmlString);
				foreach(XElement status in xml.Elements("status")){
					timeline.Add(new Status(status));
				}
			}
			
			return timeline;
		}
		
		public void UpdateStatus(string status, decimal replyTo, string source){
			WebRequestData data = TwitterAPI.UpdateStatus(this, status, replyTo, source);
			data.WriteRequestData();
		}
		
		public void DestroyStatus(decimal id){
			WebRequestData data = TwitterAPI.DestroyStatus(this, id);
			data.WriteRequestData();
		}
		
		public void CreateFavorite(decimal id){
			WebRequestData data = TwitterAPI.CreateFavorite(this, id);
			data.WriteRequestData();
		}
		
		public void CreateBlock(decimal id){
			WebRequestData data = TwitterAPI.CreateBlock(this, id);
			data.WriteRequestData();
		}
		
		public void DestroyFriendship(decimal id){
			WebRequestData data = TwitterAPI.DestroyFriendship(this, id);
			data.WriteRequestData();
		}
	}
}