using System;
using System.Configuration;
using System.Windows;
using System.Windows.Media;
using System.Windows.Media.Imaging;

namespace Hiyoko.Themes{
	public static class ApplicationSettingsBaseExtension{
		public static void CopyTo(this ApplicationSettingsBase source, ApplicationSettingsBase dest){
			foreach(SettingsProperty prop in source.Properties){
				if(dest[prop.Name] != source[prop.Name]){
					dest[prop.Name] = source[prop.Name];
				}
			}
		}
	}
	
	public abstract class UpgradeOnceApplicationSettingsBase : ApplicationSettingsBase{
		public UpgradeOnceApplicationSettingsBase(){}
		public UpgradeOnceApplicationSettingsBase(string key) : base(key){}
		
		[NoSettingsVersionUpgrade]
		[UserScopedSetting]
		[DefaultSettingValue("false")]
		public virtual bool IsUpgradedSettings{
			get{
				return (bool)this["IsUpgradedSettings"];
			}
			set{
				this["IsUpgradedSettings"] = value;
			}
		}
		
		protected override void OnSettingsLoaded(object sender, SettingsLoadedEventArgs e){
			base.OnSettingsLoaded(sender, e);
		}
		
		public void UpgradeOnce(){
			if(!this.IsUpgradedSettings){
				this.Upgrade();
				this.IsUpgradedSettings = true;
			}
		}
	}
	
	public class ImageBrushSettings : UpgradeOnceApplicationSettingsBase{
		public ImageBrushSettings(){}
		public ImageBrushSettings(string key) : base(key){}
		
		[UserScopedSetting]
		[DefaultSettingValue("")]
		public string ImageFile{
			get{
				return (string)this["ImageFile"];
			}
			set{
				this["ImageFile"] = value;
			}
		}
		
		[UserScopedSetting]
		[DefaultSettingValue("None")]
		public TileMode TileMode{
			get{
				return (TileMode)this["TileMode"];
			}
			set{
				this["TileMode"] = value;
			}
		}
		
		[UserScopedSetting]
		[DefaultSettingValue("None")]
		public Stretch Stretch{
			get{
				return (Stretch)this["Stretch"];
			}
			set{
				this["Stretch"] = value;
			}
		}
		
		[UserScopedSetting]
		[DefaultSettingValue("Left")]
		public AlignmentX AlignmentX{
			get{
				return (AlignmentX)this["AlignmentX"];
			}
			set{
				this["AlignmentX"] = value;
			}
		}
		
		[UserScopedSetting]
		[DefaultSettingValue("Top")]
		public AlignmentY AlignmentY{
			get{
				return (AlignmentY)this["AlignmentY"];
			}
			set{
				this["AlignmentY"] = value;
			}
		}
		
		[UserScopedSetting]
		[DefaultSettingValue("1.0")]
		public double Opacity{
			get{
				return (double)this["Opacity"];
			}
			set{
				this["Opacity"] = value;
			}
		}
		
		public ImageBrush GetImageBrush(){
			var bmp = new BitmapImage();
			bmp.BeginInit();
			bmp.UriSource = new Uri(this.ImageFile, UriKind.RelativeOrAbsolute);
			bmp.EndInit();
			var brush = new ImageBrush(bmp){
				TileMode = this.TileMode,
				Stretch = this.Stretch,
				AlignmentX = this.AlignmentX,
				AlignmentY = this.AlignmentY,
				Opacity = this.Opacity
			};
			if(this.TileMode != TileMode.None){
				brush.TileMode = this.TileMode;
				brush.ViewportUnits = BrushMappingMode.Absolute;
				brush.Viewport = new Rect(0, 0, bmp.Width, bmp.Height);
			}
			return brush;
		}
	}
}