/*
	$Id: AboutForm.cs 6 2009-12-26 00:58:57Z catwalk $
*/
using System;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Interop;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Shapes;
using System.Windows.Threading;
using System.Reflection;

namespace Hiyoko.Forms{
	using WinForms = System.Windows.Forms;
	using Gdi = System.Drawing;
	
	public partial class AboutForm : Window{
		public AboutForm(){
			this.InitializeComponent();
			
			string version = WinForms.Application.ProductVersion.ToString();
			string build = Assembly.GetExecutingAssembly().GetName().Version.Build.ToString();
			string rev = Assembly.GetExecutingAssembly().GetName().Version.Revision.ToString();
			this.versionTextBlock.Text = String.Format("ver{0} build{1} rev{2}.", version, build, rev);
			object[] copyrightArray = Assembly.GetExecutingAssembly().GetCustomAttributes(typeof(AssemblyCopyrightAttribute), false);
			if((copyrightArray != null) && (copyrightArray.Length > 0)){
				this.copyrightTextBlock.Text =  ((AssemblyCopyrightAttribute)copyrightArray[0]).Copyright;
			}
		}
		
		private void Close_CanExecute(object target, CanExecuteRoutedEventArgs e){
			e.CanExecute = true;
		}
		
		private void Close_Execute(object target, ExecutedRoutedEventArgs e){
			this.Close();
		}
	}
}