/*
	$Id: Hiyoko.cs 6 2009-12-26 00:58:57Z catwalk $
*/
using System;
using System.IO;
using System.Windows;
using System.Windows.Input;
using System.Windows.Threading;
using System.Configuration;
using IronPython.Hosting;
using IronPython.Modules;
using Hiyoko.Forms;
using Hiyoko.Utilities;

namespace Hiyoko{
	public partial class Program : Application{
		private PythonEngine pythonEngine = null;
		private ApplicationSettings settings;
		private CommandLine commandLine;
		
		protected override void OnStartup(StartupEventArgs e){
			if(!ApplicationProcess.IsFirst){
				ApplicationProcess.InvokeRemote("Show");
				this.Shutdown();
			}else{
				ApplicationProcess.Actions.Add("Show", new Action(delegate{
					this.Dispatcher.BeginInvoke(DispatcherPriority.Normal, new Action(delegate{
						if(this.MainWindow != null){
							this.MainWindow.Show();
							this.MainWindow.Activate();
						}
					}));
				}));
				//System.Windows.Forms.Application.EnableVisualStyles();
				
				// R}hC
				this.commandLine = new CommandLine();
				
				// ݒǂݍ
				this.settings = new ApplicationSettings("Application");
				this.settings.UpgradeOnce();
				
				// MainForm
				Window form = new MainForm();
				this.MainWindow = form;
				if(!(this.settings.IsResident && (this.commandLine.Options.ContainsKey("hide")))){
					form.Show();
				}
				
				// IronPython
				EngineOptions options = new EngineOptions();
				options.ShowClrExceptions = true;
				options.ClrDebuggingEnabled = true;
				options.ExceptionDetail = false;
				this.pythonEngine = new PythonEngine(options);
				
				this.pythonEngine.LoadAssembly(System.Reflection.Assembly.GetExecutingAssembly());
				ClrModule clr = (ClrModule)this.pythonEngine.Import("clr");
				
				// StartupXNvgs
				if(this.settings.StartupScriptPath == null){
					this.settings.StartupScriptPath = Environment.GetFolderPath(Environment.SpecialFolder.Personal) + @"\HiyokoStartup.py";
				}
				if(File.Exists(this.settings.StartupScriptPath)){
					try{
						string result = null;
						using(MemoryStream standardOutput = new MemoryStream()){
							this.pythonEngine.SetStandardOutput(standardOutput);
							this.pythonEngine.ExecuteFile(this.settings.StartupScriptPath);
							result = System.Text.ASCIIEncoding.ASCII.GetString(standardOutput.ToArray());
						}
						MainForm.Outputs.Add(new MessageOutputItem(result));
					}catch(Exception ex){
						MainForm.Outputs.Add(new ErrorOutputItem(ex.ToString()));
					}
				}
				
				// AJEgݒ
				if(String.IsNullOrEmpty(this.settings.AccountUsername)){
					SettingsForm settings = new SettingsForm();
					settings.ShowDialog();
				}
			}
			base.OnStartup(e);
		}
		
		protected override void OnExit(ExitEventArgs e){
			base.OnExit(e);
			if(ApplicationProcess.IsFirst){
				this.pythonEngine.Dispose();
				this.settings.Save();
			}
		}
		
		public static PythonEngine PythonEngine{
			get{
				Program prog = Application.Current as Program;
				return (prog != null) ? prog.pythonEngine : null;
			}
		}
		
		public static MainForm MainForm{
			get{
				return Application.Current.MainWindow as MainForm;
			}
		}
		
		public static ApplicationSettings Settings{
			get{
				Program prog = Application.Current as Program;
				return (prog != null) ? prog.settings : null;
			}
		}
	}
}