from System import *;
from System.Windows import *;
from System.Windows.Input import *;
from System.Windows.Threading import *;
from Hiyoko import *;

def Startup(sender):
	mainForm = Application.Current.MainWindow;
	BindKeys(mainForm);
	RefreshTimeline(mainForm);

def BindKeys(mainForm):
	mainForm.InputBindings.Add(KeyBinding(HiyokoCommands.AbortCommunication, KeyGesture(Key.Escape, ModifierKeys.None, "Esc")));
	HiyokoCommands.AbortCommunication.InputGestures.Add(KeyGesture(Key.Escape, ModifierKeys.None, "Esc"));
	mainForm.InputBindings.Add(KeyBinding(HiyokoCommands.Refresh, KeyGesture(Key.F5, ModifierKeys.None, "F5")));
	HiyokoCommands.Refresh.InputGestures.Add(KeyGesture(Key.F5, ModifierKeys.None, "F5"));
	
	mainForm.TimelinePanel.StatusEdit.InputBindings.Add(KeyBinding(HiyokoCommands.UpdateStatus, KeyGesture(Key.Enter, ModifierKeys.Control, "Ctrl+Enter")));
	HiyokoCommands.UpdateStatus.InputGestures.Add(KeyGesture(Key.Enter, ModifierKeys.Control, "Ctrl+Enter"));
	mainForm.TimelinePanel.StatusEdit.InputBindings.Add(KeyBinding(ComponentCommands.ScrollPageUp, KeyGesture(Key.PageUp, ModifierKeys.None, "PgUp")));
	mainForm.TimelinePanel.StatusEdit.InputBindings.Add(KeyBinding(ComponentCommands.ScrollPageDown, KeyGesture(Key.PageDown, ModifierKeys.None, "PgDn")));
	mainForm.TimelinePanel.StatusEdit.InputBindings.Add(KeyBinding(HiyokoCommands.ShortenUrl, KeyGesture(Key.U, ModifierKeys.Control, "Ctrl+U")));
	HiyokoCommands.ShortenUrl.InputGestures.Add(KeyGesture(Key.U, ModifierKeys.Control, "Ctrl+U"));
	mainForm.TimelinePanel.StatusEdit.InputBindings.Add(KeyBinding(HiyokoCommands.UploadImage, KeyGesture(Key.P, ModifierKeys.Control, "Ctrl+P")));
	HiyokoCommands.UploadImage.InputGestures.Add(KeyGesture(Key.P, ModifierKeys.Control, "Ctrl+P"));
	
	mainForm.TimelinePanel.TimelineList.InputBindings.Add(KeyBinding(ApplicationCommands.Copy, KeyGesture(Key.C, ModifierKeys.Control, "Ctrl+C")));
	mainForm.TimelinePanel.TimelineList.InputBindings.Add(KeyBinding(ApplicationCommands.Copy, KeyGesture(Key.Insert, ModifierKeys.Control, "Ctrl+Insert")));
	mainForm.TimelinePanel.TimelineList.InputBindings.Add(KeyBinding(HiyokoCommands.ReplyTo, KeyGesture(Key.R, ModifierKeys.Control, "Ctrl+R")));
	HiyokoCommands.ReplyTo.InputGestures.Add(KeyGesture(Key.R, ModifierKeys.Control, "Ctrl+R"));
	mainForm.TimelinePanel.TimelineList.InputBindings.Add(KeyBinding(HiyokoCommands.Retweet, KeyGesture(Key.E, ModifierKeys.Control, "Ctrl+E")));
	HiyokoCommands.Retweet.InputGestures.Add(KeyGesture(Key.E, ModifierKeys.Control, "Ctrl+E"));

def RefreshTimeline(mainForm):
	HiyokoCommands.Refresh.Execute(None, mainForm.TimelinePanel);

Application.Current.Dispatcher.BeginInvoke(DispatcherPriority.Normal, Action[object](Startup), "");