/*
	$Id: Extensions.cs 34 2010-01-23 03:16:20Z catwalk $
*/

using System;

namespace Hiyoko.Utilities{
	public static class Extensions{
		public static void ThrowIfNull(this object obj){
			if(obj == null){
				throw new ArgumentNullException();
			}
		}
		
		public static void ThrowIfNull(this object obj, string message){
			if(obj == null){
				throw new ArgumentNullException(message);
			}
		}
		
		public static void ThrowIfOutOfRange(this int n, int min, int max){
			if((n < min) || (max < n)){
				throw new ArgumentOutOfRangeException();
			}
		}
		
		public static void ThrowIfOutOfRange(this int n, int min, int max, string message){
			if((n < min) || (max < n)){
				throw new ArgumentOutOfRangeException(message);
			}
		}
	}
}