(defun-wiki-inline2 page (text page target name1 value1 name2 value2)
	(set-wikivar 'text 'page 'target)
	(motor-raw "[[link:../../wiki.hml/[[Proj]]/[[page]]")
	(if name1
		(progn	(setvar 'wiki_name1 name1
				'wiki_value1 value1)
			(motor-raw "?[[name1]]=[[value1]]")))
	(if name2
		(progn	(setvar 'wiki_name2 name2
				'wiki_value2 value2)
			(motor-raw "&[[name2]]=[[value2]]")))
	(if (not-emptyp target)
			(motor-raw ":[[target]]"))
	(if text
			(motor-raw " [[text]]]]")
		(motor-raw " [[page]]]]")))

(defun-wiki-inline2 proj (text proj page target name1 value1 name2 value2)
	(setvar 'wiki_text text
		'wiki_proj proj
		'wiki_page page
		'wiki_target target)
	(motor-raw "[[link:../../wiki.hml/[[proj]]/[[page]]")
	(if name1
		(progn	(setvar 'wiki_name1 name1
				'wiki_value1 value1)
			(motor-raw "?[[name1]]=[[value1]]")))
	(if name2
		(progn	(setvar 'wiki_name2 name2
				'wiki_value2 value2)
			(motor-raw "&[[name2]]=[[value2]]")))
	(if (not-emptyp target)
			(motor-raw ":[[target]]"))
	(if text
			(motor-raw " [[text]]]]")
		(motor-raw "]]")))

(defun-wiki-inline2 imagefile (alt name)
	(setvar 'wiki_alt alt
		'wiki_name name)
	(motor-raw "[[image:../../file.hml?Proj=[[Proj]]&Filename=[[name]]:class=frame [[alt]]]]")
)

(defun-wiki-inline2 filelink (text name target)
	(setvar 'wiki_text text
			'wiki_name name
			'wiki_target target)
	(cond (
			(emptyp target)
			(if (not-emptyp text)
					(motor-raw "[[link:../../file.hml?Proj=[[Proj]]&Filename=[[name]] [[text]]]]")
				(motor-raw "[[link:../../file.hml?Proj=[[Proj]]&Filename=[[name]]]]")
			)
		)
		(	1
			(if (not-emptyp text)
					(motor-raw "[[link:../../file.hml?Proj=[[Proj]]&Filename=[[name]]:[[target]] [[text]]]]")
				(motor-raw "[[link:../../file.hml?Proj=[[Proj]]&Filename=[[name]]:[[target]]]]")
			)
		)
	)
)

(defun-wiki-link ShowLogin ()
	(motor-raw "showLogin();")
)

(defun-wiki-link GotoPage (page)
	(if page
			(motor-raw (concat "gotoPage('" (js page) "');"))
		(motor-raw "gotoPage(Page);")
	)
)

(defun-wiki-link EditPage (page)
	(if page
			(motor-raw (concat "gotoPage('" (js page) "',{'Edit':'1'});"))
		(motor-raw "gotoPage(Page,{'Edit':'1'});")
	)
)

(defun-wiki-link NewPageForm ()
	(motor-raw "gotoPage($F($(this)['Page']),{'Edit':'1'});return false;")
)

(defun-wiki-link Logout ()
	(motor-raw "opLogout();")
)

(defun-wiki-link SubmitForm (page)
	(motor-raw (concat "SubmitForm(this,'" (js page) "');return false;"))
)

(defun-wiki-command PageIndex (vpage vtitle)
	($sqlite3 'database
		(wiki-page-index nil (wikivar vpage) (wikivar vtitle))
	)
)

(defun-wiki-command PageIndexCategory (cat vpage vtitle)
	($sqlite3 'database
		(wiki-page-index cat (wikivar vpage) (wikivar vtitle))
	)
)

(defun-wiki-command PageIndexSpecial (vpage vtitle)
	($sqlite3 'database
		(wiki-page-index-special (wikivar vpage) (wikivar vtitle))
	)
)

(defun-wiki-command CategoryIndex (vname)
	($sqlite3 'database
		(wiki-category-index (wikivar vname))
	)
)

(defun-wiki-command AddCategory (cat)
	(if Writer
			($sqlite3 'database
				(wiki-add-category cat)
			)
	)
)

(defun-wiki-command DelCategory (cat)
	(if Writer
		($sqlite3 'database
			(wiki-delete-category cat)
		)
	)
)

(defun-wiki-command WikiSearch (key vpage vtitle vsp)
	(wiki-search key (wikivar vpage) (wikivar vtitle) (wikivar vsp))
)

(defun-wiki-command WikiHistory (page vdate)
	(if Reader
			($sqlite3 'database
				(wiki-page-backup-list page (wikivar vdate))
			)
	)
)

(defun-wiki-command WikiDiff (page otime ntime vo1 vo2 vn1 vn2)
	(if Reader
			(wiki-diff page otime ntime vo1 vo2 vn1 vn2)
	)
)
