/*
	呼出し元からスキャンデータ（オドメトリ含む）を受け取り
	スキャン時の自己位置を修正するプログラム
*/
#include <stdio.h>
#include <math.h>
#include <stdlib.h>
#include "aroundmap.h"
#include "localize.h"

struct pos getodometori(int filenum);

int main(int argv,char *argc[])
{
	FILE *fpscan,*fpconv,*fpbefore;
	char scanfilename[6],convfilename[7];
	int filenum;
	char s[128];
	double scanx,scany;
	struct pos NTPos,NFPos,OTPos,OFPos;
	int i;
	double costh,msinth,sinth;
	double bcosth,bmsinth,bsinth;
	const double D2R = 3.14159265358979323846/180.0;
	int end;
	double dth,dist;
	
	NTPos.x = 0;
	NTPos.y = 0;
	NTPos.th = 0;
	NFPos.x = 0;
	NFPos.y = 0;
	NFPos.th = 0;
	OTPos.x = 0;
	OTPos.y = 0;
	OTPos.th = 0;
	OFPos.x = 0;
	OFPos.y = 0;
	OFPos.th = 0;

	/*  filenum*/end = atoi(argc[1]);

	for(filenum = 0;filenum <= end; filenum += 1 )
	{
		//マッチング対象のスキャンデータファイルからオドメトリを抜き出す
		NFPos = getodometori(filenum);
/*		sprintf(scanfilename,"0%d",filenum);
		if((fpscan = fopen(scanfilename,"r")) == NULL)
		{
			fprintf(stderr,"I could not open %s",scanfilename);
		}
		fgets(s,255,fpscan);
		sscanf(s,"%lf %lf %lf %*s",&NFPos.x,&NFPos.y,&NFPos.th);
		fclose(fpscan);
//		printf("%lf %lf %lf\n",NFPos.x,NFPos.y,NFPos.th);
*/		
		//マッチング前のスキャンデータ描画用
		bcosth = cos(NFPos.th * D2R);
		bmsinth = -sin(NFPos.th * D2R);
		bsinth = sin(NFPos.th * D2R);

		//マッチングに利用する位置姿勢を作成するための変換用変数作成
		dth = NFPos.th - OFPos.th;
		dist = sqrt(pow(OFPos.x - NFPos.x,2)+pow(OFPos.y - NFPos.y,2));
		
		//次回の変数作成のために古い今の位置を保存
		OFPos.x = NFPos.x;
		OFPos.y = NFPos.y;
		OFPos.th = NFPos.th;

		//マッチングに利用する位置姿勢の作成
		NFPos.th = dth + OTPos.th;
		NFPos.x = dist * cos(NFPos.th*D2R) + OTPos.x;
		NFPos.y = dist * sin(NFPos.th*D2R) + OTPos.y;
		
		//マッチングに利用するマップの作成
		aroundmap(NFPos.x,NFPos.y,NFPos.th);
		
		//マッチングによる位置姿勢の修正
		NTPos = localize(filenum,NFPos.x,NFPos.y,NFPos.th);
				
		//マッチング後のスキャンデータ描画用
		costh = cos(NTPos.th * D2R);
		msinth = -sin(NTPos.th * D2R);
		sinth = sin(NTPos.th * D2R);

		//スキャンデータファイルを開く
		sprintf(scanfilename,"0%d",filenum);
		if((fpscan = fopen(scanfilename,"r")) == NULL)
		{
			fprintf(stderr,"I could not open %s\n",scanfilename);
		}
		//位置姿勢修整後のファイル
		sprintf(convfilename,"l0%d",filenum);
		if((fpconv = fopen(convfilename,"w")) == NULL)
		{
			fprintf(stderr,"I could not open %s\n",convfilename);
		}
		//位置姿勢修整前のファイル
		sprintf(convfilename,"b0%d",filenum);
		if((fpbefore = fopen(convfilename,"w")) == NULL)
		{
			fprintf(stderr,"I could not open %s\n",convfilename);
		}
		
		//スキャンデータをグローバル座標上に展開
		for(i = -1;fgets(s,255,fpscan) != NULL;i++)
		{
			if(i >=0)
			{
				sscanf(s,"%*s %lf %lf",&scanx,&scany);
				fprintf(fpconv,"a %lf %lf\n",
					scanx * costh + scany * msinth + NTPos.x,
					scanx * sinth + scany * costh + NTPos.y);
				sscanf(s,"%*s %lf %lf",&scanx,&scany);
				fprintf(fpbefore,"a %lf %lf\n",
				scanx * bcosth + scany * bmsinth + NFPos.x,
				scanx * bsinth + scany * bcosth + NFPos.y);
			}
		}
		fclose(fpscan);
		fclose(fpconv);
		fclose(fpbefore);
		
		//修整後の位置姿勢情報を保存
		OTPos = NTPos;
		
	}  
	return 0;
}

struct pos localize(int filenum,double oldpositionx,double oldpositiony,double oldpositionth)
{
  const int NOOVER = 0;
  const int OVER = 1;
  const int SCAN_DIST = 4900;
  const int L_MAX = 200;
  const double R2D = 180.0/3.14159265358979323846;
  const double D2R = 3.14159265358979323846/180.0;
  FILE *fpmap,*fpscan;
  char scanfilename[6];
  int over = NOOVER;
  double x,y,th;
  double kx,ky,kth;
  double dExt,dEyt,dEth;
  double E;
  double d,dmin,dist;
  double mapx[15000],mapy[15000];
  double scanx[2000],scany[2000];
  double convx[2000],convy[2000];
  double map_taiou_x[2000],map_taiou_y[2000];
  char s[256];
  double R00,R01,R10,R11;
  int i,j;
  int mappoint_num,scan_num,point_num;
  int Loop_count;

  struct pos oldposition;
  struct pos newposition;

  kx=0.003;
  ky=0.003;
  kth=0.000000001;

  x = 0;
  y = 0;
  th = 0;

  if((fpmap = fopen("aroundmap.map","r")) == NULL)
    {
      fprintf(stderr,"I could not open aroundmap.map¥n");
    }
  for(i = 0;fgets(s,255,fpmap) != NULL;i++)
  {
    sscanf(s,"%*s %lf %lf",&mapx[i],&mapy[i]);
  }
  mappoint_num = i;
  fclose(fpmap);

  sprintf(scanfilename,"0%d",filenum);
  if((fpscan = fopen(scanfilename,"r")) == NULL)
    {
      fprintf(stderr,"I could not open %s",scanfilename);
    }
  i = -1;
  while(fgets(s,255,fpscan) != NULL)
    {
      if(i == -1)
      {
//        sscanf(s,"%lf %lf %lf",&oldposition.x,&oldposition.y,&oldposition.th);
oldposition.x = oldpositionx;
oldposition.y = oldpositiony;
oldposition.th = oldpositionth;

      }
      else
      {
        sscanf(s,"%*s %lf %lf",&scanx[i],&scany[i]);
      	if( (fabs(scanx[i]) < 1000 && fabs(scany[i]) < 1000) || fabs(scanx[i]) > 6000 || fabs(scany[i]) > 6000)
	{
	  continue;
	}
        for(j=0;j<i;j++)
	{
	  if( ((scanx[i]-scanx[j])*(scanx[i]-scanx[j]) + (scany[i]-scany[j])*(scany[i]-scany[j])) < SCAN_DIST )
	    {
	      over = OVER;
	      break;
	    }
	}
      }
      if(over == NOOVER)
	{
	  i++;
	}
      over = NOOVER;
    }
  scan_num = i;
  fclose(fpscan);
  for(Loop_count=0;Loop_count<=L_MAX;Loop_count++)	//規定回数最急降下法により近づける
    {
      R00=cos(th);
      R01=sin(th);
      R10=-sin(th);
      R11=cos(th);

      point_num=0;		//最急降下法に用いる数初期化 スキャンデータ何点に付いてマッチングを行ったか
      dExt=dEyt=dEth=0.0;	//偏微分値を初期化
      E=0.0;			//評価関数を初期化
      //対応点探索と表示のループ
      for(j=0;j<=scan_num;j++)	//j番めのスキャン点をオドメトリデータをつかってマップの座標系に落とす
	{
	  convx[j]=(int)(R00*(scanx[j])+R10*(scany[j])+x);
	  convy[j]=(int)(R01*(scanx[j])+R11*(scany[j])+y);
	  dmin=100000000.0;

	  for(i=0;i<=mappoint_num;i++)	//i番目のマップ点と比較し一番距離の短いところを探す
	    {
	      d=(mapx[i]-convx[j])*(mapx[i]-convx[j])+(mapy[i]-convy[j])*(mapy[i]-convy[j]);
	      if(d<=dmin)
		{
		  dmin=d;
		  map_taiou_x[j]=mapx[i];
		  map_taiou_y[j]=mapy[i];
		}
	    }

	if(dmin>1000000.0)	//30cm以上離れてたら最急降下法にもちいない
	{
		continue;
	}

	if(Loop_count>100)
	{
		if(dmin>40000.0)
		{//20cm以上離れてたら最急降下法に用いない
			continue;
		}
		if(Loop_count>400)
		{
			if(dmin>400.0)
			{//2cm以上離れてたら最急降下法に用いない
				continue;
				}
		}
	}
	  point_num++;
	  dist=(map_taiou_x[j] - convx[j])*(map_taiou_x[j] - convx[j])	//距離を・・・dminじゃないの？
	    +(map_taiou_y[j] - convy[j])*(map_taiou_y[j] - convy[j]);
	  E=E+dist;

	  dExt += (-2.0*(map_taiou_x[j] - convx[j]));	//xに関して偏微分するとこ〜なる
	  dEyt += (-2.0*(map_taiou_y[j] - convy[j]));
	  dEth =dEth
	    + 2.0*( scanx[j]*R01 + scany[j]*R00)
	    *(map_taiou_x[j] - scanx[j]*R00 +scany[j]*R01-x)
	    + 2.0*(-scanx[j]*cos(th) + scany[j]*sin(th))
	    *(map_taiou_y[j] - scanx[j]*R01 -scany[j]*R00-y) ;

	}


      //変数の更新
      x += (-kx*dExt);
      y += (-ky*dEyt);
      th -= kth*dEth;
    }
  newposition.th = oldposition.th + th * R2D;
  newposition.x = oldposition.x + x * cos(newposition.th*D2R) + y * -sin(newposition.th*D2R);
  newposition.y = oldposition.y + x * sin(newposition.th*D2R) + y * cos(newposition.th*D2R);
//  printf("x = %lf,y = %lf,th = %lf\n",x,y,th);
//  printf("newposition.x = %lf,newposition.y = %lf,newposition.th = %lf \n",newposition.x,newposition.y,newposition.th);
  return newposition;
}

struct pos getodometori(int filenum)
{
	struct pos Pos;
	FILE *fp;
	char filename[6];
	char s[256];
	
	sprintf(filename,"0%d",filenum);
	if((fp = fopen(filename,"r")) == NULL)
	{
		fprintf(stderr,"i could not open %s\n",filename);
	}
	fgets(s,255,fp);
	sscanf(s,"%lf %lf %lf %*s",&Pos.x,&Pos.y,&Pos.th);
	fclose(fp);
			
	return Pos;
}
