//二つのurgデータファイルから、初期値を与えて対応点を求めるプログラム

#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <unistd.h>

#define L_MAX 1000//収束しない場合でも何回までループ回すか
#define FILENUM 20


FILE *fp_map,*fp_scan;//参照データ、入力データ用ファイル
FILE *fp_gnu,*gnu,*fp_scan_mv;//gnuplot用

int im=0,is=0,i=0,j=0,m_num=0,s_num=0,p_num =0;
long Loop_count;
char filename[64];

double map_x[1000],map_y[1000];//参照データ
double scan_nama_x[1000],scan_nama_y[1000];//生の入力データ
double scan_x[1000],scan_y[1000];//入力データを変換したもの
double map_taiou_x[1000],map_taiou_y[1000];//参照データの対応点記録用
int taiou_hantei[1000];

double E,dist;//E:評価関数（距離の２乗和） dist:距離の２乗
double d,dmin;//対応点探索用の距離の２乗
double x_odo,y_odo,th_odo;//オドメトリの数値（初期値）
double xt,yt,th;//オドメトリの誤差
double dExt,dEyt,dEth;//評価関数の偏微分
double kx,ky,kth;//最急降下法用の係数
double R00,R01,R10,R11;//回転行列

int startflag = 0;

double dlength;
double dth;

	
int main(int argc, char **argv)
{
	FILE *fp,*fp2,*fp3,*fp_mapdat;
	FILE *log;
	double x,y;
	double odox[256],odoy[256],odoth[256];
	double dodox[256],dodoy[256],dodoth[256];
	double ododox[256],ododoy[256],ododoth[256];
	char str[128];
	char s[128];
	int filenum;
	
	
	if((log = fopen("log.txt","w")) == NULL)	//プラットフォームのオドメトリが入ってるファイル
	{
		printf("can not open log.txt \n");
		exit(1);
	}
	
	if((fp3 = fopen("scandat_conv_to_makemap.txt","r")) == NULL)	//プラットフォームのオドメトリが入ってるファイル
	{
		printf("can not open scandat_conv_to_makemap.txt \n");
	}
	while(fgets(s, 256, fp3) != NULL)
	{
		sscanf(s,"%lf %lf %lf \n",&odox[i],&odoy[i],&odoth[i]);
//		printf("%lf %lf %lf\n",odox[i],odoy[i],odoth[i]);
		i++;
	}
	fclose(fp3);
	i = 0;
	
	for(filenum = 0 ; filenum <= FILENUM ; filenum++)
	{
		sprintf(filename,"0%d",filenum);
		fp_scan=fopen(filename,"r");
		if(filenum == 0)
		{
			fp_mapdat = fopen("mapdat.dat","w");
			while(fgets(s, 256, fp_scan) != NULL)
			{
				if(startflag!=0)
				{
					fprintf(fp_mapdat,"%s",s);
				}
				startflag ++;
			}
			startflag = 0;
			fclose(fp_scan);
//			fclose(fp_mapdat);
printf("filenum = %d end\n",filenum);
		}
		else
		{
			sprintf(filename,"0%d",filenum-1);
printf("filename = %s\n",filename);
			if((fp_map=fopen(filename,"r")) == NULL)
			{
				printf("filecan not open\n");
				exit(1);
			}
printf("filenum = %d\n",filenum);

			gnu=popen("gnuplot","w");  
			fprintf(gnu,"set xrange[-5000:10000]\n");
			fprintf(gnu,"set yrange[-5000:5000]\n");
printf("gnu opened\n");
			m_num = s_num = 0;
			startflag =0;
			while(fgets(s,256,fp_map)!=NULL)
			{
//			printf("%s",s);
				if(startflag != 0)
				{
					sscanf(s,"%d %lf %lf",&im,&map_x[im],&map_y[im]);
					m_num++;
				}
				startflag ++;
			}
printf("マップデータロード\n");
			startflag = 0;
			while(fgets(s,256,fp_scan)!=NULL)
			{
				if(startflag != 0)
				{
					sscanf(s,"%d %lf %lf",&is,&scan_nama_x[is],&scan_nama_y[is]);
					s_num++;
				}
				startflag ++;
			}
printf("スキャンデータロード\n");
			startflag = 0;
printf("date inputted\n");
			//初期設定
			//オドメトリの値入力
			/*
			printf("\n x no odometory=");
			scanf("%lf",&x_odo);
			printf("\n y no odometory=");
			scanf("%lf",&y_odo);
			printf("\n theta no odometory=");  
			scanf("%lf",&th_odo);
			*/
printf("odox[%d] = %lf odoy[%d] = %lf odoth[%d] = %lf\n",filenum,odox[filenum],filenum,odoy[filenum],filenum,odoth[filenum]);
			dlength=sqrt(pow((double)odox[filenum]-(double)odox[filenum-1],2)+pow((double)odoy[filenum]-(double)odoy[filenum-1],2));
			if(dlength!=0)
			{	//dthはラジアン
				dth = atan(((double)odoy[filenum]-(double)odoy[filenum-1])/((double)odox[filenum]-(double)odox[filenum-1]))-odoth[filenum-1]*3.14/180.0;
			}
			else
			{
				dth = 0;
			}
			//変数の初期値設定
			xt=dlength * cos(dth);
			yt=dlength * sin(dth);
			th=(odoth[filenum] - odoth[filenum-1])*3.14/180;
			
printf("dlength = %lf dth = %lf\n",dlength,dth);
			
printf("odometori inputted\n");
			/*
			//最急降下法の更新式の係数を入力
			printf("\n");
			printf("\n x no keisuu=");
			scanf("%lf",&kx);
			printf("\n y no keisuu=");
			scanf("%lf",&ky);
			printf("\n theta no keisuu=");  
			scanf("%lf",&kth);
			*/  
			kx=0.001;
			ky=0.0005;
			kth=0.000000001;


printf("xt = %lf yt = %lf th = %lf\n",xt,yt,th);


			fp_gnu=fopen("taioutenn.dat","w");
			fp_scan_mv=fopen("scan_mv.dat","w");   
printf("gnu opend\n");
			for(Loop_count=0;Loop_count<=L_MAX;Loop_count++)
			{
//printf("%d\n",Loop_count);

				//回転行列
				R00=cos(th);
				R01=sin(th);
				R10=-sin(th);
				R11=cos(th);

				p_num=0;
				dExt=dEyt=dEth=0.0;  
				E=0.0;
				rewind(fp_gnu);
				rewind(fp_scan_mv);
				//対応点探索と表示のループ
				for(j=0;j<=s_num;j++)
				{

					scan_x[j]=R00*(scan_nama_x[j])+R10*(scan_nama_y[j])+xt;
					scan_y[j]=R01*(scan_nama_x[j])+R11*(scan_nama_y[j])+yt;
					dmin=100000000.0;

					for(i=0;i<=m_num;i++)
					{
						d=(map_x[i]-scan_x[j])*(map_x[i]-scan_x[j])+(map_y[i]-scan_y[j])*(map_y[i]-scan_y[j]);
						if(d<=dmin)
						{
							dmin=d;
							map_taiou_x[j]=map_x[i];
							map_taiou_y[j]=map_y[i];
						}      
					}

					if(fabs(scan_nama_x[j]) < 1000 &&fabs(scan_nama_y[j]) < 1000  )continue;       
					if(fabs(map_taiou_x[j]) < 1000 &&fabs(map_taiou_y[j]) < 1000  )continue;
					if(fabs(scan_nama_x[j]) > 3000 &&fabs(scan_nama_y[j]) > 3000  )continue;       
					if(fabs(map_taiou_x[j]) > 3000 &&fabs(map_taiou_y[j]) > 3000  )continue;

					if(dmin>90000.0)
					{
						continue;
					}

					if(Loop_count>100)
					{
						if(dmin>40000.0)
						{//20cm以上離れてたら最急降下法に用いない
							continue;
						}
						if(Loop_count>400)
						{
							if(dmin>400.0)
							{//2cm以上離れてたら最急降下法に用いない
								continue;
			  				}
						}
					}

					p_num++;
					dist=(map_taiou_x[j] - scan_x[j])*(map_taiou_x[j] -  scan_x[j])+(map_taiou_y[j] -  scan_y[j])*(map_taiou_y[j] -  scan_y[j]);
					E=E+dist;

					dExt =dExt + (-2.0*(map_taiou_x[j] - scan_x[j]));
					dEyt =dEyt + (-2.0*(map_taiou_y[j] - scan_y[j]));
					dEth =dEth 
					+ 2.0*( scan_nama_x[j]*R01 + scan_nama_y[j]*R00)
					*(map_taiou_x[j] - scan_nama_x[j]*R00 +scan_nama_y[j]*R01-xt) 
					+ 2.0*(-scan_nama_x[j]*cos(th) + scan_nama_y[j]*sin(th))
					*(map_taiou_y[j] - scan_nama_x[j]*R01 -scan_nama_y[j]*R00-yt) ;

					fprintf(fp_scan_mv,"%lf %lf\n",scan_x[j],scan_y[j]);
					if(Loop_count==999)
					{
						fprintf(log,"%d miss\n",filenum);
						printf("%d %lf %lf\n",j,scan_x[j],scan_y[j]);
					}
					fprintf(fp_gnu,"%lf %lf\n",scan_x[j],scan_y[j]);
					fprintf(fp_gnu,"%lf %lf\n\n\n",map_taiou_x[j],map_taiou_y[j]);      

				}


				//変数の更新
				xt=xt -kx*dExt;
				yt=yt -ky*dEyt;
				th=th -kth*dEth;

				//printf("%lf %d %ld\n",E/p_num,p_num,Loop_count);
		//		fprintf(gnu,"plot 'taioutenn.dat' w line, '0%d' u 2:3,'scan_mv.dat' \n",filenum-1);
				fflush(gnu);
				if(E/p_num<169)
				{
					printf("		shuusoku simasita!!\n");
					printf("xt=%lf,yt=%lf,tht=%lf\n",xt,yt,th*180/3.1415);
					printf("%d %lf %lf %lf\n",filenum,xt,yt,th*180/3.1415);
					fprintf(log,"%d syuusoku\n",filenum);
					break;
				}  
				/*
				if(Loop_count>300)
				{  
					printf("shuusoku simasenndesita...orz\n");
					break;
				}
				*/

			}    
			fclose(fp_gnu);
			fclose(fp_scan_mv);
			pclose(gnu);  
			fclose(fp_scan);  
			fclose(fp_map);
		}
		
		if(filenum == 1)
		{
			dodox[filenum-1] = xt;
			dodoy[filenum-1] = yt;
			dodoth[filenum-1] = th*180/3.14;
		}
		else
		{
			dodoth[filenum - 1] = dodoth[filenum - 2] + th * 180/3.14;
			dodox[filenum - 1] = xt*cos(dodoth[filenum -2]*3.1415/180.0) - yt*sin(dodoth[filenum -2]*3.1415/180.0) + dodox[filenum -2];
			dodoy[filenum - 1] = xt*sin(dodoth[filenum -2]*3.1415/180.0) + yt*cos(dodoth[filenum -2]*3.1415/180.0) + dodoy[filenum -2];
		}
		fprintf(fp_mapdat,"%d %lf %lf %lf\n",filenum,dodox[filenum-1],dodoy[filenum-1],dodoth[filenum-1]);
	}
fclose(fp_mapdat);
fclose(log);


	if((fp2 = fopen("downGrobal_saikyuu_to_makemap.dat","w")) == NULL)	//最終出力ファイル
	{
		printf("can not downGroval_saikyuu_tom_makemap.dat \n");
	}
	for(i = 0; i <= FILENUM; i++)
	{
		sprintf(filename,"d0%d",i);
		if((fp3 = fopen(filename,"w")) == NULL)	//最終出力ファイル
		{
			printf("can not downGroval_saikyuu_tom_makemap.dat \n");
		}
		sprintf(filename,"0%d",i);

		if((fp = fopen(filename,"r")) == NULL)
		{
			printf("can not %s \n",filename);
		}
	
		while(fgets(s, 256, fp) != NULL)
		{
			sscanf(s,"%*s %lf %lf",&x,&y);
			fprintf(fp2,"%d %lf %lf\n",i,x * cos( dodoth[i] * 3.14 / 180.0) + y * -sin( dodoth[i] * 3.14 / 180.0) + dodox[i],
			                             x * sin( dodoth[i] * 3.14 / 180.0) + y * cos( dodoth[i] * 3.14 / 180.0) + dodoy[i]);
			fprintf(fp3,"%d %lf %lf\n",i,x * cos( dodoth[i] * 3.14 / 180.0) + y * -sin( dodoth[i] * 3.14 / 180.0) + dodox[i],
			                             x * sin( dodoth[i] * 3.14 / 180.0) + y * cos( dodoth[i] * 3.14 / 180.0) + dodoy[i]);
			//fprintf(fp2,"%d %lf %lf\n",i,x * cos( odoth_delta[i-1] * 3.14 / 180.0) + odox_delta[i] ,y * sin( odoth_delta[i-1] * 3.14 / 180.0) + odoy_delta[i]);
		}
		fclose(fp);
		fclose(fp3);
	}
	
	fclose(fp2);
	return 0; 
	exit(0);
}


