/*
  GPS のデータ取得を行う
*/

#include "GpsHandler.h"
#include "SerialCtrl.h"
#include "CommonGpsCtrl.h"
#include "NmeaState.h"
#include "Delay.h"
#include <pthread.h>


enum {
  UB = 0,
  SF = 1,
};
static earth_t GpsData[2];
static pthread_mutex_t Mutex;
static char BinData[1024];
static int BinSize = 0;


void *gps_thread(void* args) {
  gps_args_t* info = static_cast<gps_args_t*>(args);
  pthread_mutex_init(&Mutex, NULL);

  CommonGpsCtrl gps[2];
  if (! gps[UB].connect(info->ub_device.c_str(), 38400)) {
    fprintf(stderr, "U-Blocks::connect: %s\n", gps[UB].what());
  }
  //fprintf(stderr, "|%s|\n", info->sf_device.c_str());
  if (! gps[SF].connect(info->sf_device.c_str(), 38400)) {
    fprintf(stderr, "StarFire::connect: %s\n", gps[SF].what());
  }

  SerialCtrl con;
  if (con.connect(info->bin_device.c_str(), 38400) < 0) {
    fprintf(stderr, "Binary data::connect: %s\n", con.what());
  }

  NmeaState nmea[2];
  while (1) {
    // バイナリデータの受信
    //if (con.isConnected()) {
    pthread_mutex_lock(&Mutex);
    int n = con.recv(&BinData[BinSize], 512, 20);
    //fprintf(stderr, "n = %d\n", n);
    if (n > 0) {
      BinSize += n;
    }
    pthread_mutex_unlock(&Mutex);
    //}

    // GPS データの受信処理と記録
    for (int i = 0; i < 2; ++i) {
      if (gps[i].isConnected()) {
        std::string line;
        while (gps[i].updateState(&nmea[i], line)) {
       	  //printf("%d %s\n",i,line.c_str());
	  // !!!
        }
      }
      //fprintf(stderr, "%d: latitude: %f, longitude: %f\n",
      //i, nmea[i].latitude, nmea[i].longitude);
      pthread_mutex_lock(&Mutex);
      GpsData[i].latitude = nmea[i].latitude;
      GpsData[i].longitude = nmea[i].longitude;
      pthread_mutex_unlock(&Mutex);
    }
    delay(1000);
  }

  return 0;
}



void getGps(earth_t& u_block, earth_t& star_fire,
	    char* raw_data, int* data_size) {

  pthread_mutex_lock(&Mutex);
  u_block = GpsData[UB];
  star_fire = GpsData[SF];

  memmove(raw_data, BinData, BinSize);
  *data_size = BinSize;
  BinSize = 0;

  pthread_mutex_unlock(&Mutex);
}
