#ifndef HOIST_TASK_H
#define HOIST_TASK_H

#define POSLOCK pthread_mutex_lock(&mupos)
#define POSUNLOCK pthread_mutex_unlock(&mupos)

extern const double  D2R;// = 3.14159265358979323846/180.0;

extern const int  ON;// = 1;	//URGport_name の　timeflag
extern const int  OFF;// = 0;
extern const int  SLOW;// = 3;

extern int obstacle;

extern const int MAP;// = 0; //マッチモードかマップモードかのフラグ
extern const int MATCH;// = 1;
extern int modeflag;	//MAPでマップ作成モード　MATCHでローカライゼイションモード

extern struct timeval tzstart,tzend;

extern double robopos_x, robopos_y, robopos_t, robopos_h; //robotの位置姿勢とステアリング角

extern pthread_mutex_t mupos;
extern double deltax,deltay,deltath;//マッチング無しの位置姿勢情報と、最終マッチング時の位置姿勢情報との差分

extern bool hoist_connect(void);
extern void hoist_idle(void);
extern void hoist_speedDown(void);
extern void hoist_speedUp(void);
extern void hoist_setSpeed(int velocity_km);
extern void hoist_getPosition(int* x, int* y, double* degree);
//extern int hoist_getVelocity(void);
extern void hoist_getVelocity(int& velocity, int& steerDegree);
extern int hoist_getBlock();

//extern int SH2open(void);	//SH2との通信初期化関数
//extern void query(char* strmchar,char* returnstr);	//strmcharをマイコンに渡して returnstrを受け取り表示

extern void myGround(double height);
extern void myCylinder(double radius, double height, int sides);
extern void drawRobot(void);
extern void display(void);
extern void resize(int w, int h);
extern void key_func(unsigned char key, int x, int y);	//openGLの関数 キーを押されたときの動作を記述 t=速度マックス m=中間速度 s=ストップ q＝プログラム終了
extern void skey_func(int key, int x, int y);	//特殊キーの動作を記述 ↑=1ビット加速 ↓=1ビット減速 ←=中間速度 →=右に2度ハンドルを切ったとみなす
extern void init(void);
extern void *getURG(void *arg);
extern void getpos(void);
extern double gettime(void);
extern void init_URGthread(void);

#endif /* !HOIST_TASK_H */
