/*!
  \file
  \brief ZjAJ[̑xƎȈʒu擾

  \author Satofumi KAMIMURA

  SH7045F ̎ƌ̃vÓATKI  HoistHost.c QlɂB
*/

#include "SeniorCarCtrl.h"
#include "ThreadCreator.h"
#include "HoistTask.h"
#include "SH2.h"
#include <string>


struct SeniorCarCtrl::pImpl {
  std::string error_message;
  ThreadCreator thread;
  int velocity;

  pImpl(void)
    : error_message("no error."), thread(idle_thread, NULL), velocity(0) {
  }

  static int idle_thread(void* dummy) {

    hoist_idle();

    return 0;
  }
};


SeniorCarCtrl::SeniorCarCtrl(void) : pimpl(new pImpl) {
}


SeniorCarCtrl::~SeniorCarCtrl(void) {
}


const char* SeniorCarCtrl::what(void) {
  return pimpl->error_message.c_str();
}


bool SeniorCarCtrl::connect(void) {
  bool ret = hoist_connect();
  if (! ret) {
    return ret;
  }
  pimpl->thread.run();

  return ret;
}


void SeniorCarCtrl::setVelocity(int velocity_km) {

  //fprintf(stderr, "%d, %d\n", pimpl->velocity, velocity_km);
#if 0
//2007N1112
//nC@~h@XgbvgɕύX
  for (int i = pimpl->velocity; i > velocity_km; --i) {
    hoist_speedDown();
    --pimpl->velocity;
  }
  for (int i = pimpl->velocity; i < velocity_km; ++i) {
    hoist_speedUp();
    ++pimpl->velocity;
  }
#endif

  if(pimpl->velocity != velocity_km)
  {
printf("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!\n");
printf("pimple->velocity = %d velocity_km = %d \n",pimpl->velocity,velocity_km);
  char dummy[32];
  pimpl->velocity = velocity_km;
#if 1
  	if(velocity_km == 4)
  	{
  		query("t",dummy);
  	}
  	else if(velocity_km < 4 && velocity_km >0)
  	{
  		query("m",dummy);
  	}
  	else if(velocity_km == 0)
  	{
  		query("s",dummy);
  	}
  	else
  	{
  		query("s",dummy);
  	}
  	
#endif
  }
}


int SeniorCarCtrl::getVelocity(void) {
  int velocity = 0;
  int steer_degree = 0;
  hoist_getVelocity(velocity, steer_degree);

  return velocity;
}


void SeniorCarCtrl::getPosition(int* x, int* y, double* degree) {
  hoist_getPosition(x, y, degree);
}
