/*
  ڕWoHւ̈ړ{bgǏ]vO(V~[Vp)

  Satofumi KAMIMURA

  $Id$
*/

#include "SimulationCtrl.h"
#include "CoordinateCtrl.h"
#include "SdlVideo.h"
#include "InputHandler.h"
#include "MathUtils.h"
#include "ThreadCreator.h"
#include "FollowLineCalc.h"
#include "Delay.h"
#include <string>


struct SimulationCtrl::pImpl {
  enum {
    // 80, ԗ֕
    // 125, a
    // 560, gbh
    // 910, zC[x[X
    SteerLimit = 20,		// [degree]
    WaitDelay = 1,
  };

  std::string error_message;
  SdlVideo video;
  SDL_Surface* scr;
  InputHandler input;

  class ThreadArgs {
  public:
    int steer_degree;
    double straight_vel;
    Position<int> robot_position;
    const CoordinateCtrl* target_crd;
    Position<int> target_position;
    RobotCtrlInterface* run;

    ThreadArgs(RobotCtrlInterface* obj)
      : steer_degree(0), straight_vel(0.0), target_crd(NULL), run(obj) {
    }
  };
  ThreadArgs thread_args;
  ThreadCreator thread;

  pImpl(RobotCtrlInterface* obj)
    //scr(video.show()) {
    : error_message("no error."), scr(NULL),
      thread_args(obj), thread(update_thread, &thread_args) {
  }

  static int update_thread(void* args) {
    ThreadArgs* info = static_cast<ThreadArgs*>(args);

    double rotate_vel =
      tan(info->steer_degree * D2R) / WheelBase * info->straight_vel;

    //fprintf(stderr, "rotate acc: %f, steer_degree: %d\n", rotate_vel, info->steer_degree);

    double radian = info->robot_position.angle.to_rad();
    //fprintf(stderr, "rotate_vel: %f [rad], %f\n", rotate_vel, radian);
    //fprintf(stderr, "rotate_vel: %f [deg], %f\n", rotate_vel / D2R, radian / D2R);

    info->robot_position.angle = rad(radian + rotate_vel);
    info->robot_position.x +=
      static_cast<int>(info->straight_vel * cos(radian));
    info->robot_position.y +=
      static_cast<int>(info->straight_vel * sin(radian));

    delay(WaitDelay);
    printf("%d\t%d\t# %d\n",
	   info->robot_position.x, info->robot_position.y,
	   static_cast<int>(info->robot_position.angle.to_deg()));

    double omega = info->straight_vel * info->steer_degree * D2R / WheelBase;
    int target_diff_degree = followLineCalc(info->run, info->target_crd,
					    info->target_position, omega,
					    info->straight_vel);

    int target_degree =
      static_cast<int>(info->steer_degree + target_diff_degree);
    info->run->setSteer(target_degree);

    return 0;
  }

  // !!! {bgԂ̍XV
  // !!! IɌĂ΂AƉ肷
  // !!! XbhłāAIɍXVdgׂ݂ȁH

  // !!! {bgւ̓͂́AiƉ]Aꂼ̈ړx
  // !!! ֐AȁH
  // !!! ނAǊpAixÂ͂ɎׂȁH

  // !!! Ǐ]ł́A
  // !!! ڕW܂ł̋ƁAΓIȎȎp΂悳
  // !!! ڕW(ixH)AڕWɑ΂鑀Ǌp肷邾
};


SimulationCtrl::SimulationCtrl(void) : pimpl(new pImpl(this)) {
}


SimulationCtrl::~SimulationCtrl(void) {
}


const char* SimulationCtrl::what(void) {
  return pimpl->error_message.c_str();
}


bool SimulationCtrl::updateEvent(void) {
  pimpl->input.update_all();
  return (pimpl->input.haveQuitEvent()) ? false : true;
}


bool SimulationCtrl::connect(void) {

  // `掑̏
  // !!!

  // ʂ̕`
  // !!!

  return true;
}


void SimulationCtrl::startFollowLine(void) {
  pimpl->thread.run();
}


void SimulationCtrl::setSteerOffset(int offset_degree) {
  // !!! dummy
}


void SimulationCtrl::setSteer(int degree) {
  if (degree < -pImpl::SteerLimit) {
    degree = -pImpl::SteerLimit;
  } else if (degree > +pImpl::SteerLimit) {
    degree = +pImpl::SteerLimit;
  }
  //fprintf(stderr, "steer: %d [deg]\n", degree);
  pimpl->thread_args.steer_degree = degree;
}


void SimulationCtrl::setVelocity(int velocity_km) {
  pimpl->thread_args.straight_vel = velocity_km * 100000.0 / 3600.0;
}


void SimulationCtrl::follow_line(const CoordinateCtrl* crd,
				 const Position<int>& position) {

  pimpl->thread_args.target_crd = crd;
  pimpl->thread_args.target_position = position;
}


int SimulationCtrl::getLength_toLine(const CoordinateCtrl* crd,
				     const Position<int>& line) {

  return getLengthToLineCalc(this, crd, line);
}


void SimulationCtrl::stop(void) {
  setVelocity(0);
}


int SimulationCtrl::getVelocity(void) {

  // !!!
  return 0;
}


Position<int> SimulationCtrl::getPosition(const CoordinateCtrl* crd) {
  return pimpl->thread_args.robot_position;
}


CoordinateCtrl* SimulationCtrl::getCoordinate(void) {
  return NULL;
}
