/* 両方で評価　マッチングができたかどうかの履歴 
   台形の領域　旋回時考慮
   底辺の半分が50cmと40cm
   
   2回何も検出しなければ　進めるようにする
   300mぐらいで条件を緩める
   
   URG関係が入っている、いまはGPSからデータを取得するのもこの中に
   
*/

#include <pthread.h>
#include "scipBase.h"
#include "scip1.h"
#include "scip2.h"
#include "scipUtil.h"
#include "URG_Ctrl.h"
#include "HoistTask.h"
#include "localize3.h"
#include "aroundmap.h"
#include "GpsHandler.h"
#include <string>

#define URGLOCK pthread_mutex_lock(&URGport_name->muurg)
#define URGUNLOCK pthread_mutex_unlock(&URGport_name->muurg)

extern  int connectCheck(std::string&, std::string&, std::string&, std::string&);

struct URGport_name
{
  tPort *port;
  char *filename;
  int timeflag;
  int tag;
  pthread_mutex_t muurg;
};

struct URGport_name URGport_name0;
struct URGport_name URGport_name1;
struct URGport_name URGport_name2;

const int TOPON = 1;	//一番したかどうか
const int MIDLE = 2;

int obstacle = 0;

int init_gnuplot(FILE **fp);
void connectCheck(tPort **port, const char *dev);
void makefilename(int Topflag,int filenum,struct URGport_name *URGport_name,char name[],char log[],char log2[]);
void logfileopen(int Topflag,char name[],char log[],char log2[],FILE **fpn,FILE **fp,FILE **fp2);
void writeodometori(int Topflag,FILE **fpn,FILE **fp,FILE **fp2,double x,double y,double th,double unowtime);
void writeURG(int Topflag,FILE **fpn,FILE **fp,FILE **fp2,int *scan);
void logfileclose(int Topflag,FILE **fpn,FILE **fp,FILE **fp2);
void logodometori(FILE **fp,char *filename,struct pos Pos);
void out_gnuplot(FILE **gnu,int filenum,char name[],struct pos NTPos);
void detectblock(int *scan,int *block,int *slow);
void makeodometoridelta(struct pos NTPos,int filenum);
struct pos createURGPos(struct pos odoPos);
struct pos createROBOPos(struct pos URGPos);

void init_URGthread()
{
	//URGのポート変数を作成
	tPort *port0;
	tPort *port1;
	tPort *port2;
	
	std::string TopURG, URG, BottomURG, GPS;
	//char *URG;
	//char *BottomURG;
	//char *GPS;,ub.latitude,ub.longitude,sf.latitude,sf,longitude,str
	
	int err;	//スレッドのクリエイト失敗で非０
	pthread_t thread_urg0,thread_urg1,thread_urg2;	//スレッドの資源
	pthread_t thread_gps;

#if 0
	static gps_args_t gps_device;
	
	gps_device.ub_device = GPS;
	gps_device.sf_device = "/dev/ttyUSB2";
	gps_device.bin_device = "/dev/ttyUSB3";
#endif
	//ACM０〜３の割り当てを行う(connectcheck.cpp参照)
	//各デバイスのACM番号を確認する
	//例えばTopURGに"/dev/tty/ACM0"といったデバイス名が代入される
	connectCheck(TopURG,URG,BottomURG,GPS);
	
#if 1
	static gps_args_t gps_device;
	
	gps_device.ub_device = GPS;
	gps_device.sf_device = "/dev/ttyUSB2";
	gps_device.bin_device = "/dev/ttyUSB3";
#endif
	pthread_mutex_init(&URGport_name0.muurg,NULL);
	pthread_mutex_init(&URGport_name1.muurg,NULL);
	pthread_mutex_init(&URGport_name2.muurg,NULL);

	//各ポートをそれぞれのURGに接続、接続できたかチェック
	connectCheck(&port0,BottomURG.c_str());
	connectCheck(&port1,URG.c_str());
	connectCheck(&port2,TopURG.c_str());

	//各URGをスキップ２に変更（いらない？）
	switchToScip2(port0);
	switchToScip2(port1);
	switchToScip2(port2);

	//連続計測モードにする（BM ON）
	scip2StartStoringScan(port0);
	scip2StartStoringScan(port1);
	scip2StartStoringScan(port2);

	//URGの状態のフラグの初期化 各"log0(1,2・・・)_2.txt"等にログファイルが残される
	//port0 下段のURG　
	//port1 中断のURG
	//port2 上段のURG
	//.timeがONになるとオドメトリ、時間、GPS情報、が保存される（前回との時間差が1秒を越えるとたつ）
	//.tagがONになるとデータがTAG*ファイルに退避される（現状では速度が50m/s以下のときフラグがたつ）
	URGport_name0.port = port0;
	URGport_name0.filename = "log";
	URGport_name0.timeflag = OFF;
	URGport_name0.tag = OFF;
	URGport_name1.port = port1;
	URGport_name1.filename = "up";
	URGport_name1.timeflag = OFF;
	URGport_name1.tag = OFF;
	URGport_name2.port = port2;
	URGport_name2.filename = "down";
	URGport_name2.timeflag = OFF;
	URGport_name2.tag = OFF;
	
	//スレッドを起動
	err = pthread_create(&thread_gps,NULL,gps_thread,&gps_device);
	if(err != 0)
	{
		fprintf(stderr,"gps_thread can not create.\n");
	}

	err = pthread_create(&thread_urg0,NULL,getURG,&URGport_name0);
	if(err != 0)
	{
		printf("URG0's thread can not create.\n");
	}
	err = pthread_create(&thread_urg1,NULL,getURG,&URGport_name1);
	if(err != 0)
	{
		printf("URG1's thread can not create.\n");
	}
	err = pthread_create(&thread_urg2,NULL,getURG,&URGport_name2);
	if(err != 0)
	{
		printf("URG2's thread can not create.\n");
	}
}

//URG、GPSデータ格納用スレッド
void *getURG(void *arg)
{
	//URGのパラメータ
	const int TOPSTARTSTEP = 0;
	const int TOPENDSTEP = 1127;
	const int STEPCLUSTER = 1;

	char name[64];	    //１スキャン毎のデータを格納するファイル名
	char log[64];	      //水平、上、下向きの生データを保存するファイル名
	char log2[64];		//上記のxyデータを保存するファイル名
	FILE *fpn; //オドメトリとURGデータを1スキャン分ずつ保存するファイル用
	FILE *fp; //水平用、上向き用、下向き用を１２０秒分ずつ保存するファイル　生データ
	FILE *fp2;			//上記をxy変換したもの
	FILE *fpFodo;	//マッチングモードでの　生オドメトリ保存用ファイルポインタ
	FILE *fpTodo;	//同修整後のオドメトリ保存用のファイルポインタ
	struct URGport_name *URGport_name;	//引数を受け取るポインタ
	int stepNum;			//URGのステップナンバー保存用
	int *scan;			//データ保存用
	int Topflag = 0;	//Topflagが１のURGのみマッチングを行う　複数のURGにTopflagを立てたときの動作は保証しない
				//現状ではURGport_name.filename　が　"log"　すなわち位置番↓のURGのときに立てるようにしている
	int filenum = 0; //fpnのファイル番号　＝　スキャン番号　fp等のファイル名は　この数字をまとめる時間で割ることによって作られる

	struct pos NTPos = {0,0,0};	//新しく正しいロボットの位置　ニュー　トゥルー　ポジションの略
	struct pos NFPos = {0,0,0};	//生オドメトリを格納後　前回の正しいロボットの位置と　
					//前回,今回の生オドメトリの差分からマッチングの前のロボットの位置を計算し格納
	struct pos OTPos = {0,0,0};	//ひとつ前の正しいロボットの位置
	struct pos OFPos = {0,0,0};	//ひとつ前の生オドメトリ
	struct pos URGFPos = {0,0,0};	//NFPosから算出されるURGの位置
	struct pos URGTPos = {0,0,0};	//マッチング結果から算出されるURGの位置　ここからNTPosが算出される
	
	struct pos SOTPos = {0,0,0};	//二つ前のロボットの正しい位置
	struct pos SOFPos = {0,0,0};	//2ステップ分のオドメトリ差を算出するための２つ前の生オドメトリ、
					//NFPosとの差を取り2ステップ分のオドメトリ差とする
	struct pos SNFPos = {0,0,0};	//2つ前のロボットの正しい位置(SOTPos)に2ステップ分のオドメトリ差を足したもの
					//これとNTPosを比較してマッチングの成否を判定する

	double unowtime = 0;	//1秒以上ごとにデータを取得するための変数
	double uoldtime = 0;

	struct pos oldposition={0.0,0.0,0.0};	//生オドメトリ格納用
	
	int velocity,steer;

	FILE *gnu;	//gnuplotの描画用の保存するファイル用

	URGport_name = (struct URGport_name *)arg;
	
	
	//一番下段のURGか判定して位置番したのURGならTopflagをTopONに設定　1秒ごとの個別データを保存しマッチングに使う
	if(strcmp("log",URGport_name->filename)==0)
	{
		Topflag = TOPON;
		
		//gnuplotの初期化
		init_gnuplot(&gnu);
		printf("TOPON\n");
	}
	//中断のURGならTopflagをMIDLEに設定して障害物検出に使用
	if(strcmp("up",URGport_name->filename) == 0)
	{
		Topflag = MIDLE;
	}

	while(1)
	{
		unowtime = gettime();//経過時間を更新
		URGLOCK;
		//URGデータを更新・・・ここにあったら毎回100s以内で待つのでは？
		//障害物検出のURGのみここで更新して他は保存する回のみ更新するのがよい?
		scan=scip2GetScan(URGport_name->port,TOPSTARTSTEP,TOPENDSTEP,STEPCLUSTER,ENC_3BYTE,&stepNum);
		if(scan == NULL)	//デバッグ用　データとれてなければ
		{
			printf("can not get data　%s",URGport_name->filename);
			sleep(5);
		}
		//前回の保存より1秒以上立っていれば(マイクロ秒単位で見ているので2秒以上ということではない)
		if(unowtime - uoldtime > 1)
		{
			//マイコンから速度情報を取得
			hoist_getVelocity(velocity,steer);
			if(velocity < 50)//速度が50mm/s未満ならデータを退避する
			{
//				fprintf(stderr,"velocity = %d is under 100mm/s\n",velocity);
				URGport_name->tag = ON;
			}
			else
			{
//				fprintf(stderr,"velocity = %d is over 100mm/s\n",velocity);
				URGport_name->tag = OFF;
			}
			URGport_name->timeflag = ON;
			uoldtime = unowtime;//ここの時間の更新は50m/s以上のときでもいいかな
		}
		if(URGport_name->timeflag == ON)//オドメトリ、URGデータの保存
		{
			//ファイル名作成
			makefilename(Topflag,filenum,URGport_name,name,log,log2);
			
			//ログファイルのオープン
			logfileopen(Topflag,name,log,log2,&fpn,&fp,&fp2);
					
			unowtime = gettime();
			
			POSLOCK;
			oldposition.x = robopos_x;	//オドメトリ値確定
			oldposition.y = robopos_y;
			oldposition.th = robopos_t;
			POSUNLOCK;
				
			POSLOCK;
			
			//ログファイルへのオドメトリ書き込み
			writeodometori(Topflag,&fpn,&fp,&fp2,oldposition.x,oldposition.y,oldposition.th,unowtime);
			
			POSUNLOCK;
			
			//ログファイルへのスキャンデータ書き込み
			writeURG(Topflag,&fpn,&fp,&fp2,scan);
			
			//ログファイルを閉じる
			logfileclose(Topflag,&fpn,&fp,&fp2);
			
			//下段のURGの場合は個別ファイルにもデータを保存する
			if(Topflag == TOPON)
			{
				//マッチングモードかつデータが退避されていなければマッチングによって自己位置を修正する生オドメトリからの差分をつくる
				if(modeflag == MATCH && URGport_name->tag == OFF)
				{
					//マッチング対象のスキャンデータファイルからオドメトリを抜き出す
					NFPos = getodometori(filenum);
					
					//マッチング前のオドメトリを保存
					logodometori(&fpFodo,"Fodo.dat",NFPos);
	        
					//スキャンデータを位置情報を使ってグローバル座標上に展開する
					//このデータが地図作成に使えるかな？
					DownToGlobal(filenum,NFPos,'b');

					//filenumが2未満の場合は2つ前のfilenum-2に対応するファイルがないため
					//０初期化したPosをつかう
					if(filenum > 2)
					{
						SOFPos = getodometori(filenum - 2);
						//二つ前のオドメトリ（SOFPos）と　２つ前の修正済み位置（SOTPos）
						//からオドメトリベースの正しい位置を算出
						SNFPos = MakeRightPos(NFPos,SOFPos,SOTPos);
					}
					
					//ひとつ前のオドメトリとの差分から初期値にするのに正しいオドメトリをつくる
					NFPos = MakeRightPos(NFPos,OFPos,OTPos);
					
					//オドメトリ情報からURGの位置を算出
					URGFPos = createURGPos(NFPos);
					
					//次回の変数作成のために古い今の位置を保存
					OFPos = getodometori(filenum);

					//マッチングに利用するマップの作成
					aroundmap(URGFPos.x,URGFPos.y,URGFPos.th);

					//マッチングによる位置姿勢の修正
					URGTPos = localize(filenum,URGFPos.x,URGFPos.y,URGFPos.th);

					//URGTPosからロボットの位置を算出
					NTPos = createROBOPos(URGTPos);

					//マッチング点数の数による評価がlocalizeの時点で入っている
					//マッチングの場所がオドメトリから50cm離れていたらマッチング前の位置を採用
					if(sqrt(pow(NTPos.x - SNFPos.x,2) + pow(NTPos.y - SNFPos.y,2)) > errlength || fabs(NTPos.th - SNFPos.th) > errdeg)
					{
						printf("マッチング距離、角度エラー\n");
						fprintf(stderr,"距離エラー = %lf 角度エラー =  %lf\n",sqrt(pow(NTPos.x - SNFPos.x,2) + pow(NTPos.y - SNFPos.y,2)),fabs(NTPos.th - SNFPos.th));
						NTPos = NFPos;
					}
					
					//マッチング後のオドメトリとマッチング無しオドメトリの差分を作成
					makeodometoridelta(NTPos,filenum);
					
					//マッチング後のオドメトリを保存
					logodometori(&fpTodo,"Todo.dat",NTPos);
		
					//スキャンデータを位置姿勢情報を使ってグローバル座標上に展開する
					DownToGlobal(filenum,URGTPos,'l');
					//printf("NTP %10lf %10lf %10lf ¥n", NTPos.x,NTPos.y,NTPos.th);
					
					//修整後の位置姿勢情報を保存
					SOTPos = OTPos;
					OTPos = NTPos;
					
					//結果をgnuplotで表示
					out_gnuplot(&gnu,filenum,name,NTPos);
				}
			}
			URGport_name->timeflag = OFF;
			if(URGport_name->tag == OFF)
			{
				filenum++;
			}
		}
		else//timeflagが立っていなければ（前回の保存から1秒立っていなければ
		{
			usleep(10000);	//10msスリープ（負荷軽減用）
		}
		//障害物検出
		if(Topflag == MIDLE)
		{
			detectblock(scan,&block,&slow);
		}
		free(scan);
		URGUNLOCK;
//		fprintf(stderr,"%s¥n",URGport_name->filename);
	}

	return NULL;
}

#if 0
void hoist_dataAvoid(int avoid_flag){

  switch(avoid_flag)
  {
    case 1:
      URGport_name0.tag = ON;
      URGport_name1.tag = ON;
      URGport_name2.tag = ON;
      break;
    case 0:
      URGport_name0.tag = OFF;
      URGport_name1.tag = OFF;
      URGport_name2.tag = OFF;
      break;
  }
}
#endif

int init_gnuplot(FILE **fp)
{
		*fp = popen("gnuplot","w");	//Top-URGのデータを見る用のgnuplot
		if(*fp == NULL)
		{
			fprintf(stderr,"could not open gnuplot\n");
			return -1;
		}
//		fprintf(*fp,"set xrange[-5000:50000]\n");
//		fprintf(*fp,"set yrange[-5000:30000]\n");
		
		return 0;
}

void out_gnuplot(FILE **gnu,int filenum,char name[],struct pos NTPos)
{
	if(filenum%2 == 0)
	{
		fprintf(*gnu,"set xrange[%d:%d]\n",(int)NTPos.x-30000,(int)NTPos.x+30000);
		fprintf(*gnu,"set yrange[%d:%d]\n",(int)NTPos.y-30000,(int)NTPos.y+30000);
	        fprintf(*gnu,"plot \"map-10000_-300000_10000000_50000.map\" u 2:3 , \"path\" u 1:2 w lp, \"l%s\" u 2:3, \"Fodo.dat\" u 1:2, \"Todo.dat\" u 1:2 \n",name);
	        //map*mapを任意に設定すれば表示するマップを任意に設定可能aroundmap.mapを指定しても面白いかも
	        //pathは指定するパスファイル名を入れるとよい
	        //l%sはマッチング後のデータ
	        fflush(*gnu);
	}
}

void connectCheck(tPort **port, const char *dev)
{
	*port = scipConnect(dev);
	if(*port == NULL)
	{
		fprintf(stderr,"Could not connect to the %s \n",dev);
		exit(EXIT_FAILURE);
	}
}

void makefilename(int Topflag,int filenum,struct URGport_name *URGport_name,char name[],char log[],char log2[])
{
	char nametemp[32],logtemp[32],log2temp[32];
	
	if(Topflag == TOPON)
	{
		sprintf(name,"0%d",filenum);			//1スキャン毎の（オドメトリ、URG）データ保存用ファイル
	}
	sprintf(log,"%s%d.txt",URGport_name->filename,filenum/120);		//水平面の保存ファイル　120秒分が1つのファイルになる
	sprintf(log2,"%s%d_2.txt",URGport_name->filename,filenum/120);
	
	if(URGport_name->tag == ON)
	{
		if(Topflag == TOPON)
		{
			sprintf(nametemp,"%s",name);
			sprintf(name,"TAG0%s",nametemp);
		}
		sprintf(logtemp,"%s",log);
		sprintf(log,"TAG%s",logtemp);		//水平面の保存ファイル　120秒分が1つのファイルになる
		sprintf(log2temp,"%s",log2);
		sprintf(log2,"TAG%s",log2temp);
	}
	
			
}

void logfileopen(int Topflag,char name[],char log[],char log2[],FILE **fpn,FILE **fp,FILE **fp2)
{
	if(Topflag == TOPON)
	{
	  //while(1)
	  //{
			if((*fpn = fopen(name,"w")) == NULL)	//こいつだけはアペンドじゃなくてライトモードで開いてもよい
			{
				printf("can not open %s",name);
			}
			else
			{
			  //break;
			}
			//usleep(10000);
		}
	//}
	if((*fp = fopen(log,"a")) == NULL)
	{
		printf("can not open %s",log);
	}
	if((*fp2 = fopen(log2,"a")) == NULL)
	{
		printf("can not open %s",log2);
	}

}


static void recordBinary(FILE** fp, char* bin_data, int bin_size) {
  //fprintf(stderr, "bin_size: %d\n", bin_size);
  fprintf(*fp, " %d ", bin_size);
  for (int i = 0; i < bin_size; ++i) {
    fprintf(*fp, "%02x", (unsigned char)bin_data[i]);
  }
}


void writeodometori(int Topflag,FILE **fpn,FILE **fp,FILE **fp2,double x,double y,double th,double unowtime)
{
	earth_t ub,sf;
	int bin_size;
	char bin_data[1025];
	getGps(ub,sf, bin_data, &bin_size);
	if(Topflag == TOPON)
	{
	  fprintf(*fpn,"%lf %lf %lf %lf %.50f %.50f %.50f %.50f",x,y,th,unowtime,ub.latitude,ub.longitude,sf.latitude,sf.longitude);
	  recordBinary(fpn, bin_data, bin_size);
	  fprintf(*fpn, "\n");
	}
	fprintf(*fp,"%lf %lf %lf %lf %.50f %.50f %.50f %.50f",x,y,th,unowtime,ub.latitude,ub.longitude,sf.latitude,sf.longitude);
	recordBinary(fp, bin_data, bin_size);
	fprintf(*fp, "\n");
	
	fprintf(*fp2,"%lf %lf %lf %lf %.50f %.50f %.50f %.50f",x,y,th,unowtime,ub.latitude,ub.longitude,sf.latitude,sf.longitude);
	recordBinary(fp2, bin_data, bin_size);
	fprintf(*fp2, "\n");
}


void writeURG(int Topflag,FILE **fpn,FILE **fp,FILE **fp2,int *scan)
{
	const int TOPENDSTEP = 1127;
	const int TOPSTARTSTEP = 0;
	
	int i;
	
	for(i=TOPSTARTSTEP;i<TOPENDSTEP;i++)	//URGデータを保存
	{
		if(Topflag == TOPON)
		{
				fprintf(*fpn,"%d %d %d \n",i,(int)(scan[i]*cos(((i-560)*0.25)*D2R)),(int)(scan[i]*sin(((i-560)*0.25)*D2R)));
		}
		fprintf(*fp,"%d %d\n",i,scan[i]);
		fprintf(*fp2,"%d %d %d \n",i,(int)(scan[i]*cos(((i-560)*0.25)*D2R)),(int)(scan[i]*sin(((i-560)*0.25)*D2R)));
	}
}

void logfileclose(int Topflag,FILE **fpn,FILE **fp,FILE **fp2)
{
	if(Topflag == TOPON)
	{
		fclose(*fpn);
	}
	fclose(*fp);
	fclose(*fp2);
}

void logodometori(FILE **fp,char *filename,struct pos Pos)
{
	*fp = fopen(filename,"a");
	if(*fp == NULL)
	{
		fprintf(stderr,"could not open %s",filename);
		exit(1);
	}
	fprintf(*fp,"%d %d %lf\n",(int)Pos.x,(int)Pos.y,Pos.th);
	fprintf(*fp,"%lf %lf\n\n",500*cos(Pos.th*D2R)+Pos.x,500*sin(Pos.th*D2R)+Pos.y);
	fclose(*fp);
}

//障害物検出を行う
void detectblock(int *scan,int *block,int *slow)
{
	int i;
	int x,y;
	const int TOPENDSTEP = 1127;
	const int TOPSTARTSTEP = 0;
	static int count = 0;
	
	if(scan == NULL)	//デバッグ用
	{
		printf("can not get data");
		usleep(10000);
	}
	*slow = OFF;
	obstacle = 0;
	for(i=TOPSTARTSTEP;i<TOPENDSTEP;i++)	//URGデータを保存
	{
		x = (int)(scan[i]*cos(((i-560)*0.25)*D2R));
		y = (int)(scan[i]*sin(((i-560)*0.25)*D2R));
		//外側の範囲を指定　この中に観測点があると徐行する　またyの正負で回避行動の元となる値を設定
		if( y < 750 && y > -750 && x > 100 && x < 3000)
		{
			*slow = ON;
			if(y < 0)
			{
				obstacle++;
			}
			else if(y > 0)
			{
				obstacle--;
			}
			//内側の範囲を指定　この中に観測点があると停止する slow を初期化する
			if( y < ( -0.15 * x + 400) && y > ( 0.15 * x - 400) && x > 100 && x < 1200)
			{
				*block = ON;
				*slow = OFF;
				//止まったときはカウントを設定し、何も検出しない回数が連続3回以上になるまで停止する
				//誤認識による急発進を抑えるため
				count = 3;
				//printf("obstacle = %d\n",obstacle);
				break;
			}
		}
	}
	//停止範囲に何も検出しなかったときの処理
	if(count == 0)
	{
		*block = OFF;
	}
	else
	{
		count--;
		if(count < 0)
		{
			count = 0;
		}
	}
	
#if 0
	if(*block == ON)
	{
		printf("block\n");
	}
	else if(*slow == ON)
	{
		printf("slow\n");
	}
	else
	{
		printf("nonblock\n");
	}
#endif
}

void makeodometoridelta(struct pos NTPos,int filenum)
{
	struct pos NFPos;
	
	NFPos = getodometori(filenum);
	
	//生のオドメトリと本当の位置姿勢との差分（グローバル変数）を更新
	//hoist_getosition()で制御に渡す位置情報は生オドメトリにこの値を足したものになる
	deltax = NTPos.x - NFPos.x;
	deltay = NTPos.y - NFPos.y;
	deltath = NTPos.th - NFPos.th;
}

struct pos createURGPos(struct pos odoPos)
{
	struct pos URGPos;
	
	URGPos.x = odoPos.x + 1070*cos(odoPos.th*3.141592/180.0);
	URGPos.y = odoPos.y + 1070*sin(odoPos.th*3.141592/180.0);
	URGPos.th = odoPos.th;

	return URGPos;
}

struct pos createROBOPos(struct pos URGPos)
{
	struct pos odoPos;
	
	odoPos.x = URGPos.x - 1070*cos(URGPos.th*3.141592/180.0);
	odoPos.y = URGPos.y - 1070*sin(URGPos.th*3.141592/180.0);
	odoPos.th = URGPos.th;

	return odoPos;
}
