/*
  GPS capture sample

*/
  
#include "GpsHandler.h"


int main(int argc, char *argv[]) {

  pthread_t thread;
  gps_args_t args;
  args.ub_device = "/dev/ttyACM3";
  args.sf_device = "/dev/ttyUSB2";
  args.bin_device = "/dev/ttyUSB3";

  pthread_create(&thread, NULL, gps_thread, &args);

  for (int i = 0; i < 100; ++i) {
    earth_t ub, sf;
    int bin_size;
    char bin_data[1024];
    getGps(ub, sf, bin_data, &bin_size);

    printf("%f, %f: n = %d\n", ub.latitude, ub.longitude, bin_size);
    for (int i = 0; i < bin_size; ++i) {
      fprintf(stderr, "%02x ", static_cast<unsigned char>(bin_data[i]));
    }
    fprintf(stderr, "\n");
    sleep(1);
  }

  return 0;
}
