/*
	gcc gnuplotmulti.c -o gnuplotmulti
	
	l00　l01　といったように順番に並んだファイルを順番にプロットするプログラム
	マッチングの目指での判定に使った
*/

#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <unistd.h>

int main(int argv,char **argc)
{
	int i;
	int start,end;
	FILE *gnu;
	if(argv != 5 || !strcmp(argc[1], "--help") )
	{
		printf("使いかた:\n\t%s allmapname sign start end\n\n",argc[0]);
		printf("\tallmapname: 全域のファイルデータ名\n");
		printf("\tsign: ファイルの識別子　無し\"b\",\"c\",\"l\"等\n");
		printf("\tstart end:開始番号と終了番号\n");
		printf("ex. ./gnuplotmulti map-10000_-300000_60000_50000.map l 0 100 等\n");
		return -1;
	}
	
	start = atoi(argc[3]);
	end = atoi(argc[4]);
	
	printf("%d %d\n",start,end);
	
	gnu = popen("gnuplot","w");
	
	fprintf(gnu,"set nokey\n");
	//表示の範囲を設定できる↓
//	fprintf(gnu,"set xrange[-10000:50000]\n");
//	fprintf(gnu,"set yrange[-10000:30000]\n");
	fprintf(gnu,"plot '%s' u 2:3\n",argc[1]);

	for(i = start+1; i <= end ; i++)
	{
		fprintf(gnu,"replot '%s0%d' u 2:3\n",argc[2],i);
                fprintf(gnu,"pause 1\n");
	}
	fclose(gnu);
	return 0;
}
