/*
  ڕWoHւ̈ړ{bgǏ]vO(@p)

  Satofumi KAMIMURA
*/

#include "RobotCtrl.h"
#include "FollowLines.h"
#include "SteerOffsetHandler.h"
#include "CoordinateCtrl.h"
#include "WiiJoystick.h"
#include "Delay.h"
#include "HoistTask.h"
#include <GL/glut.h>
#include <errno.h>
#include <string.h>
#include <fstream>
#include <iterator>
#include <vector>
#include <string>

enum {
  RotateRadius = 5500,		// 񔼌a [mm]
};


static std::string error_message = "no error.";


static void printHelp(const char* program_name) {

  printf("usage:\n\t%s"
	 " <path file>\n", program_name);
}


std::istream& operator >> (std::istream& is, Grid<int>& rhs) {

  is >> rhs.x >> rhs.y;

  return is;
}


static bool loadPathData(std::vector<Grid<int> >& path_line,
			 const char* file) {

  std::ifstream fin(file);
  if (! fin.is_open()) {
    error_message = strerror(errno);
    return false;
  }

  path_line.clear();
  path_line.assign(std::istream_iterator<Grid<int> >(fin),
		   std::istream_iterator<Grid<int> >());

  fprintf(stderr, "lines: %d\n", path_line.size());
  return true;
}


static void robot_start(RobotCtrlInterface* robot) {
  //robot->setVelocity(2);
  robot->setVelocity(4);
}


static int getEmergencyOffset(void) {
  static FILE* fd = fopen("offset_log.txt", "w");

  // !!! vZꂽItZbglAO[oϐoRœǂݏo
  int points = 0;		// !!! ̒lAύX

  points = obstacle;

  int offset = points / 20;
  enum {
    MaxOffset = 10,		// [deg]
  };
  if (offset > MaxOffset) {
    offset = MaxOffset;
  } else if (offset < -MaxOffset) {
    offset = -MaxOffset;
  }
  if (fd) {
    fprintf(fd, "obstacl: %d, offset: %d\n", obstacle, offset);
    fflush(fd);
  }

  return offset;
}


static void pathFollow(RobotCtrlInterface* robot,
		       const CoordinateCtrl* path_crd,
		       std::vector<Grid<int> >& path_lines,
		       JoystickInterface& joystick) {

  int first_offset = robot->getSteerOffset();

  // ڕWoHւ̒Ǐ]
  FollowLines lines(robot, robot);
  lines.setFollowLines(path_crd, path_lines, RotateRadius);

  robot_start(robot);
  bool is_stop = false;
  while (lines.update()) {
    delay(100);

    robot->setSteerOffset(first_offset + getEmergencyOffset());

    // !!! KvɉAQɑ΂Ď~܂悤ɂ
    // Wii  A {^ĂԁA~
    //printf("hoist_getBlock() = %d\n",hoist_getBlock());
    if ((joystick.isButtonPressed(WiiJoystick::Button_A)) || (hoist_getBlock() == ON)) {
      // ~
      is_stop = true;
      robot->stop();
      continue;
    }
    if (is_stop) {
      robot_start(robot);
      is_stop = false;
    }
    if(hoist_getBlock() == SLOW)
      {
	robot->setVelocity(2);
      }
    if(hoist_getBlock() == OFF)
      {
	robot->setVelocity(4);
      }

    if (! robot->updateEvent()) {
      break;
    }
  }

  // ~ďI
  robot->stop();
}


int main(int argc, char *argv[]) {

  // ̉
  const char* path_file = NULL;
  bool simulation = false;
  for (int i = 1; i < argc; ++i) {
    if ((! strcmp("-s", argv[i])) || (! strcmp("--simulation", argv[i]))) {
      simulation = true;

    } else if ((! strcmp("-h", argv[i])) || (! strcmp("--help", argv[i]))) {
      // help ̕\
      printHelp(argv[0]);

    } else {
      // ڕWOՃf[^t@C
      path_file = argv[i];
    }
  }
  if (! path_file) {
    printHelp(argv[0]);
    exit(1);
  }

  // Ǐ]oH̐ݒ
  LinePoints path_lines;
  if (! loadPathData(path_lines, path_file)) {
    printf("loadPathData: %s\n", error_message.c_str());
    exit(1);
  }

  // Wii ̔F
  printf("Put Wiimote in discoverable mode (press 1+2) and press RETURN\n");
  WiiJoystick joystick;
  if (! joystick.connect()) {
    printf("WiiJoystick::connect: %s\n", joystick.what());
    exit(1);
  }

  // ړ{bg̏
  RobotCtrlInterface* robot;
  robot = new RobotCtrl;
  if (! robot->connect()) {
    printf("RobotCtrlInterface::connect: %s\n", robot->what());
    exit(1);
  }
  // ǊpItZbg̒
  int steer_offset = 0;
  loadSteerOffset(&steer_offset);
  robot->setSteerOffset(steer_offset);

  // Ǐ]Xbh̋N
  robot->startFollowLine();

  // oHǏ]̊Jn
  CoordinateCtrl path_crd;
  path_crd.setOrigin(robot->getCoordinate(), 0, 0, deg(0));
  pathFollow(robot, &path_crd, path_lines, joystick); //, `掑

  // I
  delete robot;
  printf("goal.\n");
  return 0;
}
