/*
	1 速度上昇等を修正
*/
#include "reg704x.h"

extern void init_CMT(void);
extern void int_cmt0(void);
extern void set_imask(int imask);
int velocity;
int steering_angle;

void init_SCI(void)	//シリアル通信のための設定
{
	int delay;
	
	SCR1 = 0;	//シリアル通信のチャンネル１のコントロール設定　送信エンプティ割り込み要求禁止　シリアル通信動作の開始禁止　送信終了割り込みノ発生禁止など
	SMR1 = 0;	//〃モード設定　歩調同期式　８ビットデータ　パリティ不可、チェック無し　ストップビット１　マルチプロセッサ機能禁止　ψクロック
	BRR1 = 22;	//ビットレート設定　38.4kbit/s　[ψ（MHz)/６４＊２＾（２ｎ−１）＊B（ビットレート）]＊１０＾６ー１
	PACRL2 = 0x0140;//PA4番ポートと３番ポートを送信データ出力（TXD1）、受信データ入力（RXD1）機能に設定
	for(delay=0; delay <= 1000 ; delay++)	////1ビット分の時間まちかな
	{
	}
	SCR1 = 0x30;	////シリアル通信の動作の開始許可
}

void init_AD(void)
{
	ADCSR0 = 0x10;	//AD変換終了後の割り込み命令禁止　AD変換停止　変換時間を８０ステート（ψ/4を選択時）←よくわからない	AN0のみ使用
	AADCR0 = 0xff;	//高速スタートモード　外部トリガからの開始許可　スキャンモード　動機サンプリング　ADDRA〜ADDRDまでをバッファに使用
	ADCSR0 = 0x30;	//AD変換開始
}

void init_MTU(void)	//エンコーダの設定
{
	TSTR = 0x00;	//タイマスタートレジスタを停止に設定
	PACRL1 |= 0x0005;//PA8とPA9をそれぞれTCLKAとTCLKBに設定
	TCR1 |= 0x07;	//チャンネル1のカウンタをチャンネル２のオーバーフローアンダーフローでカウント
	TMDR2 |= 0x04;	//タイマモードレジスタを位相計測モード１に設定
	TSTR |= 0x06;	//タイマスタートレジスタを開始に設定
}

void init_DA()
{
	PDCRL = 0;
	PDDRL = 0x0000; /* WRを H にする */
	PDIORL = 0xffff;/* PE0-PE15のポートを出力に設定する */
	PDDRL |= 0x0100; /* WRを H にする */
	PDDRL |= 0x0800; //電源を入れる
}

void init_IO(void)
{
	PECR1=0;
	PECR2=0;
	PEIOR= 0xffff;
}

void Sputc(char c)	//1バイト送信関数
{
	while(SSR1 < 0x10)
	{
	}
	TDR1= c ;	//送信用データを格納
	SSR1 &= 0x7f;	//TDRに有効なデータが書き込まれていることを示す
//	while(!((0x04 & SSR1)>>2))	////SSRのTENDビットが0なら待機
//	{
//	}
}

void prstr(char *x)	//文字列送信関数　Sputcの連続呼び出し
{
	char d;
	while(*x != 0)
	{
		d = *x++;
		if(d == '\n')	//復帰と改行の付加
		{
			Sputc(0x0d);	//復帰\r
			Sputc(0x0a);	//改行\n
		}
		else Sputc(d);
	}
}

char rxData(void)
{
	while(!(SSR1 & 0x78))
	{
	}
	if((SSR1 & 0x40)==0x40)	//RDRFビットが1ならば
	{
		SSR1 &= 0xbf;	//RDRFビットを反転
		return RDR1;
	}
	else
	{
		SSR1 = 0x80;
		return 'e';
	}
}

void DA_update(void)
{
	PDDRL &= ~0x0100;	//WRをローにしてラッチにデータを読み込む
	PDDRL |= 0x0100;	//WRをHにする
}

int main(void)
{
	int MTU2_count;	//エンコーダの値
	char rd;		//受信文字
	int dat;
	double z;
	int absvelocity;
	int abssteering_angle;
	init_SCI();	//シリアル通信の設定
	init_MTU();	//マルチファンクションタイマーの設定
	init_AD();	//ADコンバータ初期化
	init_DA();	//DAコンバータ初期化
	init_IO();
	init_CMT();
	
	set_imask(3);
	
	TCNT1 = 0;
	TCNT2 = 32768;
	prstr("Hoist3\n\n");
	
	while(1)
	{
		rd = rxData();
		if(rd == '1')
		{
		
			MTU2_count = (TCNT1 << 16);
			MTU2_count |= TCNT2;
		
			Sputc((MTU2_count/1000000000)%10+0x30);
			Sputc((MTU2_count/100000000)%10+0x30);
			Sputc((MTU2_count/10000000)%10+0x30);
			Sputc((MTU2_count/1000000)%10+0x30);
			Sputc((MTU2_count/100000)%10+0x30);
			Sputc((MTU2_count/10000)%10+0x30);	//以下　シリアル通信向の転送データ
			Sputc((MTU2_count/1000)%10+0x30);
			Sputc((MTU2_count/100)%10+0x30);
			Sputc((MTU2_count/10)%10+0x30);
			Sputc(MTU2_count%10+0x30);
			
			while(ADCSR0 < 0x70)
			{
			}
			PEDR = ADDRA0;	//測定結果をテスター等向けに出力
			dat = ADDRA0 >> 6;	//データは10ビットなのでビットシフトして格納
/*			Sputc(dat/1000+'0');	//以下　シリアル通信向の転送データ
			Sputc((dat/100)%10+'0');//生結果　電圧の順　５Vなら
			Sputc((dat/10)%10+'0');	//1023 5.00　　コメント行を省いたので　5.00のみ表示
			Sputc(dat%10+'0');	//と表示
*/			Sputc(' ');
			z=(dat)*5.0/1023;
			dat=z*100;
			Sputc(dat/100+'0');
			Sputc('.');
			Sputc((dat/10)%10+'0');
			Sputc(dat%10+'0');
			prstr("\n");
		}
		if(rd == 'u')
		{
			if((PDDRL & 0xff) <= 150)
			{
				PDDRL += 50;
			}
			prstr("speed up \n");
		}
		else if(rd == 'd')
		{
			if((PDDRL & 0xff) >= 50)
			{
				PDDRL -= 50;
			}
			prstr("speed down \n");
		}
		else if(rd == 't')
		{
			PDDRL = (PDDRL & 0xff00) | 200;		//出力電圧マックス
			prstr("top speed \n");			
		}
		else if(rd == 'm')
		{
			PDDRL = (PDDRL & 0xff00) | 100;		//出力電圧ミドル
			prstr("middle speed \n");			
		}
		else if(rd == 's')
		{
			PDDRL &= 0xff00;		//出力電圧０
			prstr("stop \n");
		}
		else if(rd == 'a')
		{
		        PDDRL &= ~0x0200;
			prstr("out put for a \n");	
		}
		else if(rd == 'h')
		{
			prstr("input h\n");
			if(PEDR & 0x10)
			{
				PEDR &= ~0x10;
			}
			else
			{
				PEDR |= 0x10;
			}
		}
		else if(rd == 'b')
		{
			prstr("input b\n");
			if(PEDR & 0x20)
			{
				PEDR &= ~0x20;
			}
			else
			{
				PEDR |= 0x20;
			}
		}
		else if(rd == 'r')
		{
			prstr("input r\n");
			PEDR |= 0x01;
			PEDR &= ~0x01;
		}
		else if(rd == 'l')
		{
			prstr("input l\n");
			PEDR |= 0x02;
			PEDR &= ~0x02;
		}
		else if(rd == 'v')
		{
			absvelocity = velocity; //30ms程度の周期で回ってくるから　２、３回目は符号が落ちるので元の値を残す
			if(absvelocity < 0)
			{
				Sputc('-');
				absvelocity *= -1;
			}
			Sputc((absvelocity/1000)%10+'0');
			Sputc((absvelocity/100)%10+'0');
			Sputc((absvelocity/10)%10+'0');
			Sputc(absvelocity%10+'0');
			prstr(" ");
			
			abssteering_angle = steering_angle;
			if(abssteering_angle < 0)
			{
				Sputc('-');
				abssteering_angle *= -1;
			}
			if(abssteering_angle > 10000)
			{
				Sputc(abssteering_angle/10000%10+'0');
			}
			if(abssteering_angle >1000)
			{
				Sputc(abssteering_angle/1000%10+'0');
			}
			Sputc(abssteering_angle/100%10+'0');
			Sputc('.');
			Sputc((abssteering_angle/10)%10+'0');
			Sputc(abssteering_angle%10+'0');
			prstr("\n");
		}
		DA_update();
		rd = 0;
	}
	
	return 0;
}
