#include	"hole_punchd.h"

void	keep_alive_check (void)
{
	struct	RepeaterTable	*next;
	struct	RepeaterTable	*prev;
	struct	RepeaterTable	*temp;

	time (&cur_time);
	prev = NULL;
	next = RepeaterTablePnt;
	while (next)
	{
		if ((cur_time - next->AccessTime) > 180)
		{
			fprintf (log_file, "%24.24s Disconnect from %s:%d %8.8s\n",
				ctime(&cur_time), inet_ntoa (next->repeater_addr.sin_addr), 
				ntohs(next->repeater_addr.sin_port), next->ar_callsign);
			fflush (log_file);
			if (prev)
			{
				prev->f_chain = next->f_chain;
				temp = next;
				next = prev->f_chain;
				free (temp);
			}
			else
			{
				RepeaterTablePnt = next->f_chain;
				free (next);
				next = RepeaterTablePnt;
			}
		}
		else
		{
			prev = next;
			next = next->f_chain;
		}
	}
}

