package iax.client.protocol.user.command;

import iax.client.protocol.call.Call;
import iax.client.protocol.frame.ProtocolControlFrame;
import iax.client.protocol.peer.Peer;

/**
 * Implements the user command that holds a call.
 */
public class HoldCall {

    public static void execute(Peer peer) {
        try {
            Call call = peer.getCall();
            ProtocolControlFrame quelchCallFrame = 
                new ProtocolControlFrame(call.getSrcCallNo(), false, call.getDestCallNo(), call.getTimestamp(), call.getOseqno(),
                        call.getIseqno(), false, ProtocolControlFrame.QUELCH_SC);
            quelchCallFrame.setMusicOnHold();
            call.handleSendFrame(quelchCallFrame);

        } catch (Exception e) {
            e.printStackTrace();
        }
    }

}