(ns anime.mass1
  (:import (java.awt Dimension Color)
           (javax.swing JFrame JPanel)))

(require 'src.math)
(alias 'mt 'src.math)

(defn L [[_ t [_ x y] [_ vx vy]]]
  (let [k 10 m 0.1]
    (- (* 0.5 m
          (+ (* vx vx) (* vy vy))
          )
       (* 0.5 k
          (+ (* x x) (* y y))
          ))))

(def A (mt/L->accer L))

(defn phys [xi]
  (let [n (/ (- (count xi) 1) 2)
        q (take n (rest xi))
        qdot (drop n (rest xi))
        qddot (rest (A ['up 0
                            (cons 'up q)
                            (cons 'up qdot)
                            ]))]
    (concat ['up]
            qdot
            qddot)))

; ['up x vx y vy]
;(defn phys [[_ x vx y vy]]
;  (let [k 10 m 0.1]
;    ['up
;     vx
;     (/ (- (* k x)) m)
;     vy
;     (/ (- (* k y)) m)
;     ]))

; ['up x y vx vy]
(def xi (ref ['up 1 0 0 -1]))

(defn anime-panel []
  (proxy [JPanel] []
    (paintComponent [g]
      (proxy-super paintComponent g)
      (.setColor g Color/BLUE)
      (let [x (+ 120 (* (mt/tref @xi 0) 100))
            y (+ 120 (* (mt/tref @xi 1) -100))]
        (.fillOval g (- x 5) (- y 5) 10 10)))
    (getPreferredSize []
      (Dimension. 240 240)
      )))

(defn make-panel []
  (let [frame (JFrame. "mass1")
        panel (anime-panel)]
    (doto frame
      (.add panel)
      (.pack)
      (.setDefaultCloseOperation JFrame/EXIT_ON_CLOSE)
      (.setVisible true))
    panel))

(let [panel (make-panel)]
  (loop [i 0]
    (if (>= i 100)
      true
      (do
        (dosync
          (ref-set xi (mt/next-iter phys @xi))
          (println @xi)
          (.repaint panel))
        (recur (inc i))
        ))))
