(ns src.optim)

(require 'src.graph)
(alias 'gr 'src.graph)

(defn eq-gr-pairs [gr-strm buf]
  (lazy-seq
    (if (empty? gr-strm)
      []
      (let [out-vals (gr/calc-all (first gr-strm))]
        (if (contains? buf out-vals)
          (cons [(get buf out-vals) (first gr-strm)]
                (eq-gr-pairs (rest gr-strm)
                             (dissoc buf out-vals)
                             ))
          (eq-gr-pairs (rest gr-strm)
                       (assoc buf out-vals (first gr-strm))
                       ))))))

