//
// AutoreleasePool.h
//

#ifndef __RAYM_AUTORELEASEPOOL_H__
#define __RAYM_AUTORELEASEPOOL_H__

#include <map>
#include <vector>

#include <Raym/Object.h>

namespace Raym
{

class AutoreleasePool : public Object
{
protected:
    AutoreleasePool();
    ~AutoreleasePool();

private:
    void add(Object *object);
    Object *autorelease();

    std::vector<Object *> _objects;

public:
    //
    static AutoreleasePool *alloc();

    //
    AutoreleasePool *init();

    //
    static void addObject(Object *object);
    static void addObject(Object *object, bool rootPool);

    virtual const char *className();
};

} // Raym

#endif // __RAYM_AUTORELEASEPOOL_H__
