//
// URLConnection.h
//

#pragma once

#include <Raym/Object.h>
#include <Raym/Data.h>
#include <Raym/URLRequest.h>
#include <Raym/URLResponse.h>
#include <Raym/Error.h>

namespace Raym
{

class URLConnection;

class URLConnectionDelegate
{
public:
    virtual bool connectionShouldUseCredentialStorage(URLConnection *connection);
};

class URLConnection : public Object
{
protected:
    URLConnection();
    ~URLConnection();

public:
    static URLConnection *alloc();
    URLConnection *initWithRequest(URLRequest *request, URLConnectionDelegate *delegate);

    virtual const char *className();

    static Data *sendSynchronousRequest(URLRequest *request, URLResponse **response, Error **error);
};

} // Raym
