//
// URLRequest.h
//

#pragma once

#include <Raym/Object.h>
#include <Raym/Dictionary.h>
#include <Raym/URL.h>

namespace Raym
{

class URLRequest : public Object
{
protected:
    URLRequest();
    ~URLRequest();

    URL *           _url;
    String *        _HTTPMethod;
    Dictionary *    _HTTPHeaderFields;

public:
    static URLRequest *alloc();
    static URLRequest *requestWithURL(URL *theURL);

    URLRequest *initWithURL(URL *theURL);

    Dictionary *allHTTPHeaderFields();
    String *HTTPMethod();
    URL *url();

    // for Mutable Class's Method
    void addValueForHTTPHeaderField(const char *value, const char *field);


//    virtual String *description();
    virtual const char *className();
};

} // Raym
