/**
 * @file PMT.h
 *
 */

#pragma once

#include "mpeg2/ts/Table.h"

namespace MPEG2
{
namespace TS
{

class PMT : public Table
{
public:
    uint8_t         _table_id;                  //  8
    uint8_t         _section_syntax_indicator;  //  1
                                                //  1  '0'
                                                //  2  reserved
    uint16_t        _section_length;            // 12
    uint16_t        _program_number;            // 16
                                                //  2  reserved
    uint8_t         _version_number;            //  5
    uint8_t         _current_next_indicator;    //  1
    uint8_t         _section_number;            //  8
    uint8_t         _last_section_number;       //  8
                                                //  3  reserved
    uint16_t        _PCR_PID;                   // 13
                                                //  4  reserved
    uint16_t        _program_info_length;       // 12
    uint8_t *       _descriptor;                //  N
    uint16_t        _element_count;
    struct _element
    {
        uint8_t     _stream_type;               //  8
                                                //  3  reserved
        uint16_t    _elementary_PID;            // 13
                                                //  4  reserved
        uint16_t    _ES_info_length;            // 12
        uint8_t *   _descriptor;                //  N
    } *             _elements;
                                                // 32  CRC

protected:
    bool decode_section();

public:
    PMT();
    ~PMT();
    void reset();
};

} // TS
} // MPEG2
