//
// Tuner.h
//

#ifndef __RY0_DEVICE_TUNER_H__
#define __RY0_DEVICE_TUNER_H__

#include <stdint.h>
#include <stdio.h>
#include "keys.h"

namespace ry0
{
namespace device
{

//
static const uint32_t MAX_DEVICES = 32;
static const uint32_t MAX_TUNERS  = MAX_DEVICES * 4;

class Tuner
{
public:

    enum Type
    {
        TYPE_NA = 0,
        ISDB_S = 1,
        ISDB_T = 2
    };

    // LNB Power
    enum LnbPower
    {
        LNB_POWER_OFF,
        LNB_POWER_11V,
        LNB_POWER_15V
    };

    static const uint32_t MAX_CHANNELS_ISDB_S = 23;
    static const uint32_t MAX_CHANNELS_ISDB_T = 112;

    class Listener
    {
    public:
        virtual void put(uint8_t *buffer, uint32_t size) = 0;
    };

public:
    Tuner() {};
    virtual ~Tuner() {};
    virtual void setListener(Listener *listener) = 0;

    virtual const char *name() = 0;
    virtual Type type() = 0;
    virtual LnbPower lnbPower() = 0;
    virtual bool getCnAgc(uint32_t *cn100, uint32_t *agc, uint32_t *maxAgc) = 0;

    virtual int channel() = 0;
    virtual bool setChannel(int channel) = 0;

    virtual bool startRecording(int fd) = 0;
    virtual int stopRecording() = 0;
    virtual bool isRecording() = 0;

    virtual bool lock() = 0;
    virtual void unlock() = 0;
    virtual bool isLocked() = 0;

    // temporary
    virtual bool startStreaming(struct sockaddr_in *) = 0;
    virtual void stopStreaming() = 0;
    virtual bool isStreaming() = 0;

    /*
    bool setRecordingFD(int recfd);
    bool setDestination(const char *host, int port);
    bool resetDestination(const char *host, int port);
    */

};
    
} // device
} // ry0

#endif // __RY0_DEVICE_TUNER_H__
