//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		iutest_core.hpp
 * @brief		iris unit test core t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2011-2012, Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see LICENSE
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_iutest_core_HPP_33560431_783B_4ae7_8FC8_6E78355CAF87_
#define INCG_IRIS_iutest_core_HPP_33560431_783B_4ae7_8FC8_6E78355CAF87_

//======================================================================
// include
#include "internal/iutest_result_reporter.hpp"
#include "internal/iutest_params_util.hpp"
#include "internal/iutest_file.hpp"

namespace iutest
{

//======================================================================
// class
/**
 * @brief	eXgŜ̊Ǘ
*/
class UnitTest : public UnitTestImpl
{
public:
	/** @private */
	static	UnitTest&	instance(void)		{ static UnitTest inst; return inst; }
	/** 
	 * @brief	UnitTest CX^X̎擾
	*/
	static	UnitTest*	GetInstance(void)	{ return &instance(); }

public:
	/**
	 * @brief	eXg TestCase ̎擾
	*/
	const TestCase*		current_test_case(void)		const	{ return m_current_testcase; }

	/**
	 * @brief	eXg TestInfo ̎擾
	 * @note	݊̂ o֐ ɂĂ܂B
	*/
	const TestInfo*		current_test_info(void)		const	{ return Test::GetCurrentTestInfo(); }

	/** V[h̎擾 */
	unsigned int		random_seed(void)			const	{ return TestEnv::current_random_seed(); }

	/** ݉ڂ̂Ԃ擾 */
	int					repeat_counter(void)		const	{ return m_repeat_counter; }

public:
	/** eXg */
	int				total_test_count(void)		const	{ return m_total_test_num; }
	/** s/eXg */
	int				test_to_run_count(void)		const	{ return m_should_run_num; }
	/** seXg */
	int				failed_test_count(void)		const	{ return get_failed_test_count(); }
	/** eXg */
	int				disabled_test_count(void)	const	{ return m_disable_num; }
	/** eXg */
	int				successful_test_count(void)	const	{ return test_to_run_count() - failed_test_count() - test_was_skipped_count(); }
	/** XLbveXg */
	int				skip_test_count(void)		const	{ return total_test_count() - test_to_run_count() + test_was_skipped_count(); }
	/** IɃXLbvꂽeXg */
	int				test_was_skipped_count(void) const	{ return get_skipped_test_count(); }

	/** eXgP[X̑ */
	int				total_test_case_count(void)	const	{ return m_testcases.size(); }
	/** seXgP[X */
	int				test_case_to_run_count(void)	const
	{
		int count=0;
		for( iuTestCases::const_iterator it = m_testcases.begin(), end=m_testcases.end(); it != end; ++it )
		{
			if( !(*it)->should_run() ) continue;
			++count;
		}
		return count;
	}
	/** eXgP[X */
	int				successful_test_case_count(void)	const
	{
		int count=0;
		for( iuTestCases::const_iterator it = m_testcases.begin(), end=m_testcases.end(); it != end; ++it )
		{
			if( !(*it)->should_run() ) continue;
			if( (*it)->failed_test_count() == 0 ) ++count;
		}
		return count;
	}
	/** seXgP[X */
	int				failed_test_case_count(void)	const
	{
		int count=0;
		for( iuTestCases::const_iterator it = m_testcases.begin(), end=m_testcases.end(); it != end; ++it )
		{
			if( !(*it)->should_run() ) continue;
			if( (*it)->failed_test_count() > 0 ) ++count;
		}
		return count;
	}

	/** eXg̎s~b */
	TimeInMillisec	elapsed_time(void)		const	{ return m_elapsedmsec; }

	/** eXgP[X̎擾 */
	const TestCase*	GetTestCase(int index)	const	{ return m_testcases[index]; }

	/** eXgǂ */
	bool			Passed(void)			const	{ return get_failed_test_count() == 0 && m_ad_hoc_testresult.Passed(); }
	/** eXgsǂ */
	bool			Failed(void)			const	{ return !Passed(); }

	/** CxgXi[̎擾 */
	TestEventListeners&	listeners(void)		const	{ return TestEnv::event_listeners(); }

protected:
	/**
	 * @brief	eXg̎s
	*/
	int Run(void);

private:
#if IUTEST_HAS_EXCEPTIONS && IUTEST_HAS_SEH
	int	RunOnMSC(void);
#endif
	int RunImpl(void);

	/**
	 * @brief	eXg̎siP[vj
	*/
	bool	RunOnce(void);

private:
	/**
	 * @brief	vO̊Jn
	*/
	void	TestProgramStart(void);

	/**
	 * @brief	Ce[ṼZbgAbv
	*/
	void	SetUpTestIteration(void);

	/**
	 * @brief	ZbgAbv
	*/
	void	EnvironmentSetUp(void);

	/**
	 * @brief	
	*/
	void	EnvironmentTearDown(void);

	/**
	 * @brief	vȌI
	*/
	void	TestProgramEnd(void);

private:
	// C̏IR[obN֐
	static void	OnExit(void)
	{
		instance().TestProgramEnd();
	}

private:
	UnitTest(void)
		: m_repeat_counter(0)
		, m_init_iutest_count(0)
		, m_current_testcase(NULL)
	{
		// ftHg|[^[Zbg
		TestEnv::SetGlobalTestPartResultReporter(&m_default_test_part_result_reporter);
		// ϐɂeXgtOw[h
		TestEnv::LoadEnviromentVariable();
	}
	~UnitTest(void)
	{
		TestEnv::ReleaseGlobalTestEnvironment();
		TestEnv::SetGlobalTestPartResultReporter(NULL);
	}

private:
	// 
	void	Initialize(void);

	int get_failed_test_count(void) const
	{
		int count = 0;
		for( iuTestCases::const_iterator it=m_testcases.begin(), end=m_testcases.end(); it != end; ++it )
		{
			if( !(*it)->should_run() ) continue;
			count += (*it)->failed_test_count();
		}
		return count;
	}

	int get_skipped_test_count(void) const
	{
		int count = 0;
		for( iuTestCases::const_iterator it=m_testcases.begin(), end=m_testcases.end(); it != end; ++it )
		{
			count += (*it)->test_was_skipped_count();
		}
		return count;
	}

#if IUTEST_HAS_PARAM_TEST
public:
	/** @private */
	ParamTestCaseHolder&	parameterized_test_registry(void)	{ return m_param_testcase_holder; }
private:
	ParamTestCaseHolder	m_param_testcase_holder;
#endif

private:
	friend class UnitTestSource;

	int m_repeat_counter;
	int m_init_iutest_count;
	const TestCase*	m_current_testcase;
	detail::DefaultGlobalTestPartResultReporter	m_default_test_part_result_reporter;

	IUTEST_PP_DISALLOW_COPY_AND_ASSIGN(UnitTest);
};

namespace detail
{

/**
 * @private
 * @internal
 * @brief	P̃eXgCX^X
*/
template<class Tester>
class TestInstance
{
public:
	// RXgN^
	TestInstance(const char* testcase, const char* name, TestTypeId id, SetUpMethod setup, TearDownMethod teardown)
		: m_mediator(UnitTest::instance().AddTestCase<TestCase>(testcase, id, setup, teardown))
		, m_info(&m_mediator, name, &m_factory)
	{
		UnitTest::instance().AddTestInfo(m_mediator.ptr(), &m_info);
	}
	// RXgN^
	TestInstance(const char* testcase, const char* name, const char*  value_params, TestTypeId id, SetUpMethod setup, TearDownMethod teardown)
		: m_mediator(UnitTest::instance().AddTestCase<TestCase>(testcase, id, setup, teardown))
		, m_info(&m_mediator, name, &m_factory)
	{
		m_info.set_value_param(value_params);
		UnitTest::instance().AddTestInfo(m_mediator.ptr(), &m_info);
	}

private:
	TestCaseMediator	m_mediator;
	TestInfo			m_info;
	iuFactory<Tester>	m_factory;
};

}	// end of namespace detail
}	// end of namespace iutest

#if !IUTEST_HAS_LIB
#  include "impl/iutest_core.ipp"
#endif

#endif
