//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		iutest_core.hpp
 * @brief		iris unit test core t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2011-2013, Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see LICENSE
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_iutest_core_HPP_33560431_783B_4ae7_8FC8_6E78355CAF87_
#define INCG_IRIS_iutest_core_HPP_33560431_783B_4ae7_8FC8_6E78355CAF87_

//======================================================================
// include
#include "internal/iutest_result_reporter.hpp"
#include "internal/iutest_params_util.hpp"
#include "internal/iutest_file.hpp"

namespace iutest
{

//======================================================================
// class
/**
 * @brief	eXgŜ̊Ǘ
*/
class UnitTest : public UnitTestImpl
{
public:
	/** @private */
	static	UnitTest&	instance(void)		{ static UnitTest inst; return inst; }
	/** 
	 * @brief	UnitTest CX^X̎擾
	*/
	static	UnitTest*	GetInstance(void)	{ return &instance(); }

public:
	/**
	 * @brief	eXg TestCase ̎擾
	*/
	const TestCase*		current_test_case(void)	const	{ return m_current_testcase; }

	/**
	 * @brief	eXg TestInfo ̎擾
	 * @note	݊̂ o֐ ɂĂ܂B
	*/
	const TestInfo*		current_test_info(void)	const	{ return Test::GetCurrentTestInfo(); }

	/** V[h̎擾 */
	unsigned int		random_seed(void)		const	{ return TestEnv::current_random_seed(); }

	/** ݉ڂ̂Ԃ擾 */
	int					repeat_counter(void)	const IUTEST_CXX_NOEXCEPT_SPEC	{ return m_repeat_counter; }

public:
	/** eXg */
	int				total_test_count(void)		const IUTEST_CXX_NOEXCEPT_SPEC	{ return m_total_test_num; }
	/** |[gΏۂ̃eXg */
	int				reportable_test_count(void)	const;
	/** s/eXg */
	int				test_to_run_count(void)		const IUTEST_CXX_NOEXCEPT_SPEC	{ return m_should_run_num; }
	/** seXg */
	int				failed_test_count(void)		const;
	/** eXg */
	int				disabled_test_count(void)	const IUTEST_CXX_NOEXCEPT_SPEC	{ return m_disable_num; }
	/** |[gΏۂ̖eXg */
	int				reportable_disabled_test_count(void) const;
	/** eXg */
	int				successful_test_count(void)	const;
	/** XLbveXg */
	int				skip_test_count(void)		const;
	/** |[gΏۂ̃XLbveXg */
	int				reportable_skip_test_count(void) const;
	/** IɃXLbvꂽeXg */
	int				test_run_skipped_count(void) const;
	/** |[gΏۂ̖IɃXLbvꂽeXg */
	int				reportable_test_run_skipped_count(void) const;

	/** eXgP[X̑ */
	int				total_test_case_count(void)	const	{ return m_testcases.size(); }
	/** seXgP[X */
	int				test_case_to_run_count(void) const;
	/** eXgP[X */
	int				successful_test_case_count(void) const;
	/** seXgP[X */
	int				failed_test_case_count(void) const;

	/** eXgsȂƂ̃Ug̎擾 */
	const TestResult* ad_hoc_testresult(void) const IUTEST_CXX_NOEXCEPT_SPEC { return &m_ad_hoc_testresult; }

	/** eXg̎s~b */
	TimeInMillisec	elapsed_time(void)		const IUTEST_CXX_NOEXCEPT_SPEC	{ return m_elapsedmsec; }

	/** eXgJñ^CX^v擾 */
	TimeInMillisec	start_timestamp(void)	const IUTEST_CXX_NOEXCEPT_SPEC	{ return m_start_timestamp; }

	/** eXgP[X̎擾 */
	const TestCase*	GetTestCase(int index)	const	{ return m_testcases[index]; }

	/** eXgǂ */
	bool			Passed(void)			const;
	/** eXgsǂ */
	bool			Failed(void)			const	{ return !Passed(); }

	/** CxgXi[̎擾 */
	TestEventListeners&	listeners(void)		const	{ return TestEnv::event_listeners(); }

protected:
	/**
	 * @brief	eXg̎s
	*/
	int Run(void);

private:
#if IUTEST_HAS_EXCEPTIONS && IUTEST_HAS_SEH
	int	RunOnMSC(void);
#endif
	int RunImpl(void);

	/**
	 * @brief	eXg̎siP[vj
	*/
	bool	RunOnce(void);

private:
	/**
	 * @brief	vO̊Jn
	*/
	void	TestProgramStart(void);

	/**
	 * @brief	Ce[ṼZbgAbv
	*/
	void	SetUpTestIteration(void);

	/**
	 * @brief	ZbgAbv
	*/
	void	EnvironmentSetUp(void);

	/**
	 * @brief	
	*/
	void	EnvironmentTearDown(void);

	/**
	 * @brief	vȌI
	*/
	void	TestProgramEnd(void);

private:
	// C̏IR[obN֐
	static void	OnExit(void)
	{
		instance().TestProgramEnd();
	}

private:
	UnitTest(void)
		: m_repeat_counter(0)
		, m_init_iutest_count(0)
		, m_start_timestamp(0)
	{
		// ftHg|[^[Zbg
		TestEnv::SetGlobalTestPartResultReporter(&m_default_test_part_result_reporter);
		// ϐɂeXgtOw[h
		TestEnv::LoadEnviromentVariable();
	}
#if defined(_MSC_VER) && _MSC_VER < 1300
public:	// VC++6.0 bug
#endif
	~UnitTest(void)
	{
		TestEnv::ReleaseGlobalTestEnvironment();
		TestEnv::SetGlobalTestPartResultReporter(NULL);
	}

private:
	// 
	void	Initialize(void);

#if IUTEST_HAS_PARAM_TEST
public:
	/** @private */
	ParamTestCaseHolder&	parameterized_test_registry(void) IUTEST_CXX_NOEXCEPT_SPEC { return m_param_testcase_holder; }

private:
	ParamTestCaseHolder	m_param_testcase_holder;
#endif

private:
	friend class UnitTestSource;

	int m_repeat_counter;
	int m_init_iutest_count;
	TimeInMillisec m_start_timestamp;
	detail::DefaultGlobalTestPartResultReporter	m_default_test_part_result_reporter;

	IUTEST_PP_DISALLOW_COPY_AND_ASSIGN(UnitTest);
};

namespace detail
{

/**
 * @private
 * @internal
 * @brief	P̃eXgCX^X
*/
template<class Tester>
class TestInstance
{
public:
	// RXgN^
	TestInstance(const char* testcase, const char* name, TestTypeId id, SetUpMethod setup, TearDownMethod teardown)
		: m_mediator(AddTestCase(testcase, id, setup, teardown))
		, m_info(&m_mediator, name, &m_factory)
	{
		UnitTest::instance().AddTestInfo(m_mediator.ptr(), &m_info);
	}
	// RXgN^
	TestInstance(const char* testcase, const char* name, const char*  value_params, TestTypeId id, SetUpMethod setup, TearDownMethod teardown)
		: m_mediator(AddTestCase(testcase, id, setup, teardown))
		, m_info(&m_mediator, name, &m_factory)
	{
		m_info.set_value_param(value_params);
		UnitTest::instance().AddTestInfo(m_mediator.ptr(), &m_info);
	}

private:
	TestCase* AddTestCase(const char* testcase, TestTypeId id, SetUpMethod setup, TearDownMethod teardown)
	{
#if !defined(IUTEST_NO_EXPLICIT_FUNCTION_TEMPLATE_ARGUMENTS)
		return UnitTest::instance().AddTestCase<TestCase>(testcase, id, setup, teardown);
#else
		return UnitTest::instance().AddTestCase(testcase, id, setup, teardown, &detail::type<TestCase>());
#endif
	}
private:
	TestCaseMediator	m_mediator;
	TestInfo			m_info;
	iuFactory<Tester>	m_factory;
};

}	// end of namespace detail
}	// end of namespace iutest

#if !IUTEST_HAS_LIB
#  include "impl/iutest_core.ipp"
#endif

#endif
