<?php
/**
 * ログのテキストを変換するためのメソッドを提供します。
 * このクラスのメソッドは全て以下の入出力を持ちます。
 * 引数
 * $room 発言が書き込まれた部屋を示すChatRoomオブジェクト。
 * $player 発言者のプレイヤーID。
 * $volume 該当するログメッセージのvolumeフィールドを示す文字列。
 * $sentence 該当するログメッセージの本文。
 * $channel 該当するログメッセージの会話チャンネルを示す文字列。
 * $type 該当するログメッセージの発言タイプを示す文字列。
 * 戻り値
 * スタイルクラス, $player, $volume, $sentenceの順に変換結果を格納した配列。変換できなかった場合はfalse。
 */
class TalkConverter {
  var $players = array();

  /**
   * プロパティ名を指定して未定義のメンバ変数を取得します。
   * このメソッドは主にユーザー定義のメッセージを取得するために使用されます。
   */
  function  __get($name) {
    global $MESSAGE;
    return $MESSAGE->$name;
  }

  /**
   * 指定されたログメッセージを遠吠えに差し替えます。
   */
  function Howl($room, $player, $volume, $sentence, $channel, $type) {
    return array('wolf-howl', $player, $volume, $this->wolf_howl);
  }
  /**
   * 指定されたログメッセージをささやきに差し替えます。
   */
  function Whisper($room, $player, $volume, $sentence, $channel, $type) {
    if ($channel == 'common') {
      return array('common-talk', $player, $volume, $this->common_talk);
    }
    elseif (strpos($channel, 'lovers') === 0) {
      return array('lovers-talk', $player, $volume, $this->lovers_talk);
    }
    return false;
  }
  /**
   * 指定されたシステムメッセージをフォーマットします。
   */
  function Notify($room, $player, $volume, $sentence, $channel, $type) {
    return array('system', null, null, null);
  }
  /**
   * 指定されたシステムメッセージを異議申し立てメッセージに差し替えます。
   */
  function Claim($room, $player, $volume, $sentence, $channel, $type) {
    $_player = $room->players[$player];
    return array("objection-{$_player->sex}", null, null, null);
  }
}
